-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chimprove_operations.p	1.1 1/21/92

chimprove_operations : using(chdescriptors, chimprove, chinternal, chphase2,
    chtransform, interpform)

  process(Q: operationsQ)
    
  declare
    
    cm: operations;
    
    i: integer;
    j: integer;
    
  begin
    
    receive cm from Q;
    
    for b in cm.cblocks[] inspect
	for stx in b.statements[] inspect
	    inspect st1 in cm.statements[stx] begin
		inspect tde in cm.ch.descriptors[st1.opcode] begin
		    if tde.improve = 'eliminate2' then
			j <- 1;
			if size of tde.families > 1 then
			    -- this test is a cheap kluge
			    if tde.families[1] > 'real' then
				j <- 2;
			      end if;
			  end if;
			while j < 3 repeat
			    i <- st1.operands[j];
			    inspect opd in cm.operands[i] begin
				if case of opd.Literal < 'none' then
				    call cm.adjust('referenced', i,
					cm.operands);
				    cm.continue <- 'true';
				    -- maybe some more literals
				    -- or discards can be dropped.
				  end if;
			      end inspect;
			    j <- j + 1;
			  end while;
		      end if;
		  end inspect;
	      end inspect;
	  end for;
      end for;
    
    return cm;
    
  end process
