-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chimprove_move.p	1.1 1/21/92

chimprove_move: using(chdescriptors, chimprove, chinternal, chtransform,
    interpform)

  process(Q: peeperQ)
    
  declare
    
    cm: peeper;
    
    sxsx: integer;
    spx: integer;
    stx: integer;
    st: ch_statement;
    opcode: opcode;
    lit: qualifier_literal;
    sox: integer;
    de: statement_descriptor;
    src: integer;
    dst: integer;
    op: ch_operand;
    
    minimum_operand_index: integer;
    
  begin
    
    minimum_operand_index <- 3;
    
    receive cm from Q;
    
    -- If possible, change the move into a discard
    -- and chain a preceding assignment or output call result.

    sxsx <- size of cm.sxs - 1;
    stx <- cm.sxs[sxsx];
    inspect st1 in cm.statements[stx] begin
	
	-- find the preceding statement (may be a interpreted or blocking)
	
	if st1.references <> 0 then
	    -- cant move across a join
	    exit unchanged;
	  end if;
	if sxsx > 0 then
	    spx := cm.sxs[sxsx - 1];
	  else 
	    spx <- stx - 1;
	    inspect st0 in cm.statements[spx]
	      begin
		if st0.locus > 'block' then
		    --   cant move in dubious sequences
		    exit unchanged;
		  end if;
	      end inspect;
	  end if;
	
	dst := st1.operands[0];
	src := st1.operands[1];
	inspect st0 in cm.statements[spx] begin
	    if st0.opcode = 'call' then
		sox <- size of st0.operands - 1;
		if st0.operands[sox] <> src then
		    exit unchanged;
		  end if;
		inspect ops in cm.operands[src] begin
		    if ops.Assignments <> 1 then
			exit unchanged;
		      end if;
		  end inspect;
		inspect opd in cm.operands[dst] begin
		    if opd.Assignments <> 1 then
			exit unchanged;
		      end if;
		  end inspect;
	      else
		inspect tde in cm.ch.descriptors[st0.opcode] begin

		    if tde.destination <> 'assigned' then
			exit unchanged;
		      end if;
		    sox <- 0;
		    if st0.operands[sox] <> src then
			exit unchanged;
		      end if;
		    if tde.improve = 'literal' then
			inspect opd in cm.operands[dst] begin
			    if opd.Assignments = 1 then
				inspect ops in cm.operands[src] begin
				    lit := ops.Literal;
				  end inspect;
				remove op from cm.operands[dst];
				op.Literal <- lit;
				insert op into cm.operands at dst;
			      end if;
			  end inspect;
		      end if;
		  end inspect;
	      end if;
	  end inspect;
	remove st from cm.statements[spx];
	remove src from st.operands[sox];
	insert dst into st.operands at sox;
	insert st into cm.statements at spx;
	remove st from cm.statements[stx];
	remove dst from st.operands[0];
	inspect opd in cm.operands[src] begin
	    if opd.Assignments = 1 then
		if opd.Id[0] >= minimum_operand_index then
		    -- This optimization may save a pass; no discard
		    -- is needed - drop 1 assignment and 2 references!
		    insert src into st.operands;
		    insert st into cm.statements at stx;
		    exit drop;		-- drop: move  src src
		  end if;
	      end if;
	  end inspect;
	st.opcode <- 'discard';
	insert st into cm.statements at stx;
	-- keep one reference for the 'discard'!
	call cm.adjust('assigned', src, cm.operands);
	cm.continue <- 'true';
      end inspect;
    
    return cm;
  
  on exit(unchanged)
    return cm;
  on exit(drop)
    return cm exception drop;
  end process
