-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chimprove_convert.p	1.1 1/21/92

chimprove_convert: using(chdescriptors, chimprove, chinternal, chtransform,
    interpform)

  process(Q: computedQ)
    
  declare
    
    cm: computed;
    
    lit: qualifier_literal;
    i: integer;
    r: real;
    
  begin
    
    receive cm from Q;
    
    block
      begin
	inspect st1 in cm.statements[cm.stx] begin
	    inspect opd in cm.operands[st1.operands[1]] begin
		select case of opd.Literal
		  where('integer')
		    reveal opd.Literal.integer;
		    i := opd.Literal.integer;
		    r <- convert of i;
		  where('real')
		    reveal opd.Literal.real;
		    r := opd.Literal.real;
		    block begin
			i <- convert of r;
		      on (Depletion)
			exit unchanged;
		      end block;
		  otherwise
		    exit unchanged;
		  end select;
		
		-- source operand is literal integer or real
		inspect de in cm.ch.descriptors[st1.opcode] begin
		    select de.families[0]
		      where('ordered_enumeration')
			reveal st1.qualifier.integer;
			if 0 <= i and i < st1.qualifier.integer
			  then
			    cm.opcode <- 'enum_lit';
			    unite cm.qual.integer from i;
			  else
			    exit unchanged;
			  end if;
		      where('integer')
			cm.opcode <- 'ilit';
			unite cm.qual.integer from i;
		      where('real')
			cm.opcode <- 'rlit';
			unite cm.qual.real from r;
		      otherwise
			exit unchanged;
		      end select;
		  end inspect;
	      end inspect;
	  end inspect;
	return cm exception constant;
      on exit(unchanged)
	return cm;
      end block;
    
  end process
