chcompile: using (chtransform, chinternal, common, unix, terminalio)
process (Q: chcompileQ)
declare
  cm: chcompile;
  cmds: charstringList;
  source: charstring;
  object: charstring;
  objcode: charstring;
  entry: charstring;
  pipe: stream;
  ok: boolean;
  output: charstring;
begin
  
  receive cm from Q;
  
  -- build full path names for source and object, plus entry point name
  source <- cm.ch.options.storeCPath | cm.progname | ".c";
  object <- cm.ch.options.storeObjPath | cm.progname | ".o";
  entry <- "CH_" | cm.progname;

  if cm.ch.options.verbose then
    if cm.ch.options.transform then
      call cm.ch.put("compile ");
    else
      call cm.ch.put("compile[" | cm.progname | "]");
    end if;
  end if;
  
  -- remove object file if it already exists so we can decide whether
  -- the compile was successful
  block begin
    pipe <- cm.ch.runcmd("rm  -f " | object, 'read');
    call pipe.pclose();
  on (others)
  end block;
  
  block begin
    -- get list of commands to invoke
    cmds <- cm.ch.options.compilecmd(entry, source, object);
    -- invoke each one in turn
    new output;
    insert 'NL' into output;
    merge "Output from command(s):" into output;
    insert 'NL' into output;
    for cmd in cmds[] inspect
      block begin
	if exists of cm.ch.options.debug["compile"] then
	  call cm.ch.put("invoke[" | cmd | "] ");
	end if;
	merge copy of cmd into output;
	insert 'NL' into output;
	pipe <- cm.ch.runcmd(cmd, 'read');
	while 'true' repeat
	  merge pipe.gets() into output;
	  insert 'NL' into output;
	end while;
      on (getstringintf.endOfInput)
	call pipe.pclose();
      on (others)
	call cm.ch.put("Problems running command: " | cmd);
	exit noGood;
      end block;
    end for;
    ok <- cm.ch.access(object, 'read');
    if not ok then
      call cm.ch.put("Object file " | object | " was not produced");
      exit noGood;
    end if;
  on exit(noGood)
    ok <- 'false';
    if not cm.ch.options.quiet then
      call cm.ch.put(output);
    end if;
  end block;
  
  if not cm.ch.options.storeC then
    block begin
      pipe <- cm.ch.runcmd("rm  -f " | source, 'read');
      call pipe.pclose();
    on (others)
    end block;
  end if;
  
  -- retrieve string copy of object code if it's to be stashed in the
  -- program object
  objcode <- "";
  if cm.ch.options.keepObj then
    block begin
      objcode <- cm.ch.getfile(object);
    on (others)
      if not cm.ch.options.quiet then
	call cm.ch.put("Unable to retrieve compiled object code");
      end if;
    end block;
  end if;

  -- remove object file unless it was to be stored
  if not cm.ch.options.storeObj then
    block begin
      pipe <- cm.ch.runcmd("rm -f " | object, 'read');
      call pipe.pclose();
    on (others)
    end block;
  end if;
  
  if ok then
    cm.object <- objcode;
    return cm;
  else
    return cm exception failure;
  end if;
end process
