-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
wininternal: using (predefined,common,cwindow,fdhandlers,terminalio,cload)
  definitions

    -- definitions for the hermes processes side of window
    openWindow: callmessage (
	cload: cloadFn,
	label: charstring,
	options: charstring,
	read: readFn,
	write: writeFn,
	close: closeFn
      )
    constant (cload,label,options)
    exit {full};
    openWindowQ: inport of openWindow {init(cload),init(label),init(options)};
    openWindowFn: outport of openWindowQ;
    
    readHandler: callmessage (
	-- read goes to a c-hermes process
	read: readFn,
	close: signalPort,
	shutdown: signalQ,
	getChar: getCharFunc,	-- get a character 
	getString: getStringFunc -- read a string 
      )
    exit {init(getChar),init(getString)};
    readHandlerQ: inport of readHandler {init(read),init(close),init(shutdown)};
    readHandlerFn: outport of readHandlerQ;
    
    writeHandler: callmessage (
	-- write goes to a c-hermes process
	write: writeFn,
	close: signalPort,
	shutdown: signalQ,
	putChar: putCharFunc,	-- print a character
	putString: putStringFunc, -- print a string
	putLine: putStringFunc	-- print a string plus a newline
      )
    exit {init(putChar),init(putString),init(putLine)};
    writeHandlerQ: inport of writeHandler {init(write),init(close),init(shutdown)};
    writeHandlerFn: outport of writeHandlerQ;
    
    closeHandler: callmessage (
	cClose: closeFn,
	read: readFn,
	write: writeFn,
	closeRead: signalPort,
	closeWrite: signalPort,
	close: signalPort
      )
    exit {init(close)};
    closeHandlerQ: inport of closeHandler 
       {init(cClose),init(read),init(write),init(closeRead),init(closeWrite)};
    closeHandlerFn: outport of closeHandlerQ;
    
  end definitions
