-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
closewin: using (predefined,common,wininternal,fdhandlers)
  process (Q: closeHandlerQ)
  declare
    args: closeHandler;
    signalRead: signalPort;
    signalWrite: signalPort;
    close: signalQ;
    cClose: closeFn;
    read: readFn;
    write: writeFn;
    signal: empty;
  begin
    receive args from Q;
    signalRead <- args.closeRead;
    signalWrite <- args.closeWrite;
    new close;
    connect args.close to close;
    cClose <- args.cClose;
    read <- args.read;
    write <- args.write;
    return args;
    receive signal from close;
    discard close;
    -- synchronize close of c functions
    call cClose();
    block 
      declare
	s: charstring;
	r: boolean;
      begin
	call read(s,r);
      on (disconnected, read.discarded)
      end block;
    block 
      declare
	r: boolean;
      begin
	call write("Die!",r);
      on (disconnected, write.discarded)
      end block;
    block begin
	send signal to signalRead;
      on (disconnected)
	-- readwin process already dead
      end block;
    block begin
	send signal to signalWrite;
      on (disconnected)
	-- writewin process already dead
      end block;
  end process
