-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: prewrap.p
-- Author: Rob Strom
-- SCCS Info: @(#)prewrap.p	1.2 3/13/90

-- polymorphprecondition:  
-- precondition for WRAP
-- Require attributes which are in the formal typestate
-- forbid attributes which are higher

prewrap : USING( tscheck, Predefined ) PROCESS ( PolymorphPreconditionInit : DeterminePreconditionInport)
  DECLARE
    FP: DeterminePreconditionCall ;
    PolymorphTypestate: Typestate; -- the typestate expected
    HigherAttributes: Typestate; -- additional attributes above typestate expected
  BEGIN
    RECEIVE FP FROM PolymorphPreconditionInit ;
    BLOCK
      BEGIN
        REVEAL FP.Statement.Qualifier.formal_typestate;
        INSPECT Source IN FP.Statement.Operands [FP.Affected_Operands[0]]
          BEGIN
            CALL FP.Services.Substitute(FP.Services, Source, FP.Statement.Qualifier.Formal_Typestate, PolymorphTypestate);
            CALL FP.Services.Involving(FP.CurrentTS, Source, PolymorphTypestate, HigherAttributes);
            MERGE PolymorphTypestate INTO FP.Required;
            MERGE HigherAttributes INTO FP.Forbidden;
          END INSPECT;
      ON (CaseError)
      END BLOCK;
    RETURN FP;
  END PROCESS
