-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: checkvar.p
-- Author: Rob Strom
-- SCCS Info: @(#)checkvar.p	1.3 3/13/90

-- check var: procedure to check whether an object name is var
checkvar : USING( tscheck, Predefined, Errors ) PROCESS ( CheckVarInit : CheckVarInport)
-- Algorithm:
-- 1. Determine whether the root object is Var:
--    1.1. If the root object is on the Constants list, then it is not Var.
--    1.2. If there is an active expression block, the root object is Var
--         if either it is the result, or if it is declared in the
--         expression block or an inner scope, else it is not Var.
--    1.3. Otherwise, the root object is Var.
-- 2. The object is Var if the root object is Var unless the object is
--    of the form [A...]CM.X[...Y],  and X is on the CONSTANTS
--    list of the callmessage definition
-- 3. If the object is NotVar, generate an error message
  DECLARE
    FP: CheckVarCall ;
  BEGIN
    RECEIVE FP FROM CheckVarInit;
    /* DetermineVar */ BLOCK
      DECLARE
        Type: Typename; -- type of a component of the object being checked
      BEGIN
        -- 1.1.
        IF (boolean # (EXISTS OF Object IN FP.Context.Constants WHERE (boolean # (Object = FP.Object.Root))))
          THEN
            EXIT NotVar;
          END IF;
        /* CheckExpressionBlock */ BLOCK
          BEGIN
            INSPECT Descriptor IN FP.Context.ExpressionBlocks WHERE(POSITION OF Descriptor = SIZE OF FP.Context.ExpressionBlocks - 1)
              BEGIN
                -- 1.2. (there's an active expression block)
                IF boolean # (FP.Object.Root = Descriptor.Result)
                  THEN
                    -- OK
                  ELSE
                    IF boolean # (ScopeOffset # ( CONVERT OF integer #  (POSITION OF Scope IN FP.Context.Scopes WHERE(boolean # (Scope = FP.Object.Root.Scope)))) >= Descriptor.Scope)
                      THEN
                        -- OK
                      ELSE
                        EXIT NotVar;
                      END IF;
                  END IF;
              END INSPECT;
          ON (NotFound)
            -- 1.3. 
            -- if we're not in an e.b., and the root is not constant,
            -- no further checks are needed.
          END BLOCK /* CheckExpressionBlock */;
        -- 2.
        /* GetRootType */ BLOCK
          BEGIN
            INSPECT RootScope IN FP.Declarations WHERE(boolean # (RootScope.Id = FP.Object.Root.Scope))
              BEGIN
                INSPECT RootDeclaration IN RootScope.Declarations WHERE(boolean # (RootDeclaration.Id = FP.Object.Root.Root))
                  BEGIN
                    REVEAL RootDeclaration.TypeName.TypeName;
                    -- normal case: an explicitly declared object
                    Type := RootDeclaration.TypeName.TypeName;
                  END INSPECT;
              END INSPECT;
          ON (CaseError) -- an implicitly declared object
            INSPECT RootDeclaration IN FP.Context.InferredDcls WHERE(boolean # (RootDeclaration.Root = FP.Object.Root))
              BEGIN
                Type := RootDeclaration.Type;
              END INSPECT; -- syntax:  element construct more idiomatic ??
          END BLOCK /* GetRootType */;
        FOR Component IN FP.Object.Components WHERE(boolean # ('true'))
          INSPECT -- syntax(!!)
            INSPECT DefinitionsModule IN FP.Definitions WHERE(boolean # (DefinitionsModule.Id = Type.ModuleId))
              BEGIN
                INSPECT Definition IN DefinitionsModule.Type_Definitions WHERE(boolean # (Definition.Id = Type.TypeId))
                  BEGIN
                    IF (boolean # (primitive_types # (CASE OF Definition.Specification) = primitive_types # ('callmessagetype')))
                      THEN
                        REVEAL Definition.Specification.Callmessage_Info;
                        IF boolean # (EXISTS OF Constant IN Definition.Specification.Callmessage_Info.Constants WHERE(boolean # (Constant = Component)))
                          THEN
                            EXIT NotVar;
                          END IF;
                      END IF;
                    INSPECT ComponentDeclaration IN Definition.Component_Declarations WHERE(boolean # (ComponentDeclaration.Id = Component))
                      BEGIN
                        Type := ComponentDeclaration.Type;
                      END INSPECT;
                  END INSPECT;
              END INSPECT;
          END FOR;
      ON EXIT(NotVar)
        /* GenerateErrorMessage */ BLOCK
          DECLARE
            ErrorMessage: Error;
            ErrorObject: ErrorObject;
          BEGIN
            NEW ErrorMessage;
            UNITE ErrorMessage.Position.APos FROM COPY OF FP.Position;
            ErrorMessage.Code <- errorcode # 'Constant';
            NEW ErrorMessage.Objects;
            UNITE ErrorObject.Objectname FROM Objectname # (COPY OF FP.Object);
            INSERT ErrorObject INTO ErrorMessage.Objects;
            INSERT ErrorMessage INTO FP.Context.ErrorMessages;   
          END BLOCK /* GenerateErrorMessage */;
      END BLOCK /* DetermineVar */;
    RETURN FP;
  END PROCESS
