-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: recheckinfer.bs
-- Author: Dan Yellin
-- SCCS Info: @(#)recheckinfer.bs	1.4 3/13/90

-- This process rechecks an inference rule that was postponed because
-- the type of one of the objects involved was unknown.  That type has
-- just become known, so the rule can now be fired provided the other
-- type is also known.  Otherwise the rule will be inserted back on
-- the backpatch table, triggered by the other object.  An inference
-- rule will always be backpatched on its argument object before it is
-- backpatched on its result object.

recheckinfer: using(predefined, type_inference, checking_table, inferredtype, 
  errors, type, positions) 
process(RecheckPort:RecheckInferQueue)
DECLARE
  RecheckCall: RecheckInferMessage;
BEGIN

  RECEIVE RecheckCall FROM RecheckPort;

  -- Invoke the inference rule checker.
  call RecheckCall.InferPort(RecheckCall.bpInfer.function,
    RecheckCall.bpInfer.resultObj, RecheckCall.bpInfer.argumentObj,
    RecheckCall.inferred, RecheckCall.newlyInferred, RecheckCall.backpatch,
    RecheckCall.errors, RecheckCall.bpInfer.position);

  return RecheckCall;
  
END process
