-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: rmain.p
-- Author: David F. Bacon
-- SCCS Info: @(#)rmain.p	1.3 3/13/90

-- this process converts between the fixed main interface of main.d and a
-- resource-manager based interface in which the created process is simply
-- passed the capabilities to some resource manager that was instantiated on 
-- its behalf by its creator.  Commands to be invoked are specified
-- via command line arguments.  Several such commands can appear,
-- separated by semicolons (which must appear as individual command
-- line args).  Any such command that is preceded by the option "-sys"
-- is invoked via the sysRMain interface and is given direct access to
-- the system-level resource manager.  All others are invoked via the
-- rMain interface as user-level programs logged in to the user name
-- specified by either the USER or LOGNAME environment variable (or
-- "anonymous" if neither variable is set)

rmain: using (main, rmain, rManager, sysRManager, userRM, common)
  linking (rManager, userRM, ac_none)

  process (q: main_q) 
    
  declare
    args: main_intf;
    sysRM: sysRManager;
    rm: rManager;
    rmInit: RManagerInitFn;
    resource: polymorph;
    junk: charstring;
    prefix: charString;
    rmain: rmainFn;
    sysRMain: sysRMainFn;
    argv: charstringList;
    userName: charString;

  begin
    rmInit := create of process rmanager;
    
    receive args from q;
    sysRM := rmInit();
    
    -- install basic system resources
    wrap copy of args.environ as resource;
    call sysRM.post("system", "environ", resource, create of process ac_none);
    wrap copy of args.CLoader as resource;
    call sysRM.post("system", "CLoader", resource, create of process ac_none);
    wrap copy of args.unix as resource;
    call sysRM.post("system", "unix", resource, create of process ac_none);
    
    -- add all the stdenv functions as resources
    wrap copy of args.std.load as resource;
    call sysRM.post("system", "load", resource, create of process ac_none);
    wrap copy of args.std.pathLoad as resource;
    call sysRM.post("system", "pathLoad", resource, create of process ac_none);
    wrap copy of args.std.readObj as resource;
    call sysRM.post("system", "readObj", resource, create of process ac_none);
    wrap copy of args.std.pathReadObj as resource;
    call sysRM.post("system", "pathReadObj", resource, 
      create of process ac_none);
    wrap copy of args.std.writeObj as resource;
    call sysRM.post("system", "writeObj", resource, create of process ac_none);
    wrap copy of args.std.libWriteObj as resource;
    call sysRM.post("system", "libWriteObj", resource, 
      create of process ac_none);
    wrap copy of args.std.store as resource;
    call sysRM.post("system", "store", resource, create of process ac_none);
    wrap copy of args.std.libStore as resource;
    call sysRM.post("system", "libStore", resource, create of process ac_none);
    wrap copy of args.std.getCwd as resource;
    call sysRM.post("system", "getCwd", resource, create of process ac_none);
    wrap copy of args.std.setCwd as resource;
    call sysRM.post("system", "setCwd", resource, create of process ac_none);
    wrap copy of args.std.terminal as resource;
    call sysRM.post("system", "terminal", resource, create of process ac_none);

    -- get user ID according to host system
    block begin
      inspect entry in args.environ["USER"] begin
	userName := entry.value;
      end inspect;
    on (NotFound)
      block begin
	inspect entry in args.environ["LOGNAME"] begin
	  userName := entry.value;
	end inspect;
      on (NotFound)
	userName := "anonymous";
      end block;
    end block;
    
    argv := args.argv;
    remove prefix from argv[0];	-- prepended to argv for each process
    remove junk from argv[0];	-- name of this program "rmain"

    -- now invoke specified commands
    while size of argv <> 0 repeat
      block declare
	semiPos: integer;
	thisArgv: charStringList;
	programName: charstring;
	sys: boolean;
      begin
	block begin
	  inspect arg in argv where (arg = ";") begin
	    semiPos <- position of arg;
	  end inspect;
	on (notFound)
	  semiPos <- size of argv;
	end block;
	extract thisArgv from arg in argv where (position of arg < semiPos);
	if size of argv <> 0 then
	  remove junk from argv[0];-- get rid of semicolon
	end if;
	if size of thisArgv = 0 then
	  exit continue;
	end if;
	-- check which interface to use for this program
	if thisArgv[0] = "-sys" then
	  sys <- 'true';
	  remove junk from thisArgv[0];
	  if size of thisArgv = 0 then
	    exit continue;
	  end if;
	else
	  sys <- 'false';
	end if;
	-- extract program name for this program, and add prefix to
	-- arg vector
	programName := thisArgv[0];
	insert copy of prefix into thisArgv at 0;
	wrap thisArgv as resource;
	call sysRM.post("system", "argv", resource, 
	  create of process ac_none);
	if sys then
	  -- invoke program using system level resource manager;
	  -- process must retrieve its argv resource before returning
	  sysRMain := create of args.std.pathLoad(programName);
	  call sysRMain(sysRM);
	else
	  rm <- userRMFn#(create of process userRM)(userName, sysRM);
	  rMain <- create of args.std.pathload(programName);
	  call rMain(rm);
	end if;
	call sysRM.delete("system", "argv");

      on exit(continue)
      end block;
      
    end while;
      
    return args;
  end process
   
