-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
x: 
using (plumberInt, plumbing, rm_init, chainedRM, makePipe, common)
linking (rmanager, chainedrm, ac_none)

  process (q: plumberIntQ)
    
  declare
    args: plumberInt;
    procInfo: procInfo;
    procInfoSet: procInfoSet;
    rmInit: rManagerInitFn;
    chainedRmInit: chainedRmInitFn;
    rmList: rmList;
    input: polymorph;
    output: polymorph;
    
  begin
    receive args from q;
    
    rmInit := procedure of process rmanager;
    chainedRmInit := procedure of process chainedRM;
    
    new procInfoSet;

    for proc in args.procs[] inspect 
	new procInfo;
	procInfo.id := proc.id;

	new rmList;
	insert rmInit() into rmList;-- primary rm is an empty one we create
	insert copy of args.procRM into rmList; -- secondary is the global one
	procInfo.rm := chainedRmInit(rmList);

	insert procInfo into procInfoSet;
      end for;
    
    for pipe in args.pipes[] inspect
	call pipe.maker(output, input);
	
	inspect proc in args.procs[pipe.source] begin
	    inspect namedPipe in proc.outputs 
		   where (namedPipe.id = pipe.id) begin
		inspect info in procInfoSet[pipe.source] begin
		    call info.rm.insert(namedPipe.name, output,
		      create of process ac_none);
		  end inspect;
	      end inspect;
	  end inspect;
		
	
	inspect proc in args.procs[pipe.sink] begin
	    inspect namedPipe in proc.inputs
		   where (namedPipe.id = pipe.id) begin
		inspect info in procInfoSet[pipe.sink] begin
		    call info.rm.insert(namedPipe.name, input,
			create of process ac_none);
		  end inspect;
	      end inspect;
	  end inspect;
		
      end for;
    
    args.info <- procInfoSet;
    
    return args;

  end process
   
    
