-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- takes a plumbing specification and instantiates it with the necessary 
-- plumbing created between processes.

plumber: using (plumber, plumberInt, launcher, plumbing, rManager,
  personalRM, chainedRM, common, acPipe, load)
linking (launcher, personalRM, chainedrm, acPipe)

  process (q: plumberQ)
   
  declare
    args: plumber;
    launcher : launcherFn;
    procInfoSet: procInfoSet;
    procInfo: procInfo;
    rmSpawn: personalRMFn;
    chainedRmInit: chainedRmInitFn;
    rmList: rmList;
    resource: polymorph;
    signalQ: signalQ;
    signalPort: signalPort;
    signal: empty;
    acPipe: acPipeFn;
    sourceAC: accessFn;
    sinkAC: accessFn;
    i: integer;
    load: load_func;
    empty: empty;
    
  begin
    launcher := procedure of process launcher;
    rmSpawn := procedure of process personalRM;
    chainedRmInit := procedure of process chainedRM;
    acPipe := procedure of process acPipe;

    receive args from q;
    
    unwrap load from args.rm.get("pathLoad", "") {init};

    new procInfoSet;

    for proc in args.procs[] inspect 
	new procInfo;
	procInfo.id := proc.id;

	new rmList;
	-- primary rm is an empty one we create
	insert rmSpawn("anonymous") into rmList;
	-- secondary is the global one
	insert copy of args.procRM into rmList;
	procInfo.rm := chainedRmInit(rmList);

	insert procInfo into procInfoSet;
      end for;
    
    for pipe in args.pipes[] inspect
	
        call acPipe(load, sourceAC, sinkAC);

	inspect proc in args.procs[pipe.source] begin
	    inspect namedPipe in proc.outputs 
		   where (namedPipe.id = pipe.id) begin
		inspect info in procInfoSet[pipe.source] begin
		    wrap empty as resource;
		    call info.rm.insert(namedPipe.name, resource, sourceAC);
		  end inspect;
	      end inspect;
	  end inspect;
		
	
	inspect proc in args.procs[pipe.sink] begin
	    inspect namedPipe in proc.inputs
		   where (namedPipe.id = pipe.id) begin
		inspect info in procInfoSet[pipe.sink] begin
		    wrap empty as resource;
		    call info.rm.insert(namedPipe.name, resource, sinkAC);
		  end inspect;
	      end inspect;
	  end inspect;
		
      end for;
    
    new signalQ;

    for proc in args.procs[] inspect
	inspect info in procInfoSet[proc.id] begin
	    connect signalPort to signalQ;
	    call launcher(proc.proc, info.rm, signalPort, args.asynchronous);
	  end inspect;
      end for;
    
    discard procInfoSet;
      
    if not args.asynchronous then
	i := 0;
	while i < size of args.procs repeat
	    receive signal from signalQ;
	    i := i + 1;
	  end while;
      end if;
    
    return args;

  end process
   
