-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: addprefix.p
-- Author: Andy Lowry
-- SCCS Info: @(#)addprefix.p	1.2 3/13/90

-- This is a filter for string pipes that addes a prefix (first
-- command line arg) to each string that passes through.

addprefix: using (rmain, stringpipe, common)

process (Q: rmainQ)
  
declare
  args: rmain;
  argv: charStringList;
  prefix: charString;
  stdin: stringQ;
  stdout: stringPort;
  s: charString;
begin
  receive args from Q;
  
  -- get argument vector and both our pipe ports
  unwrap argv from args.rm.get("argv", "") {init};
  unwrap stdin from args.rm.get("stdin", "string") {init};
  unwrap stdout from args.rm.get("stdout", "string") {init};
  
  prefix := argv[2];		-- skip shell name and program name
  
  -- now start filtering
  while 'true' repeat
    receive s from stdin;
    send (copy of prefix) | s to stdout;
  end while;
  
end process
