-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: timestamp.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)timestamp.p	1.2 3/13/90"
-- description: 
-- this module receives requests for the timestamp of a Hermes object.
-- It finds the timestamp of the object and returns it.  If the object doesn't
-- exist it gives it the timestamp -1.  It also stores
-- the timestamp in a cache so future requests for the same object
-- can be answered by a cache lookup.
timestamp: using(timestamp,unix,unixstat)
process(initQ: timestampInitQ)

declare
   initArgs: timestamp!timestampInit;
   stat: unixstat!statMtimeFunc;
   access: unix!access_func;
   q: timestamp!tsrequestQ;
   tscache: timestamp!tscache;

begin
   receive initArgs from initQ;
-- get needed functions
   stat <- initArgs.stat;
   -- the follwoing param must be copied according to interface
   access := initArgs.access;
-- return the tsrequest function
   new q;
   connect initArgs.tsFn to q;
   return initArgs;

-- initialize cache
   new tscache;

-- now wait and process requests
   while 'true' repeat
     block declare
       args: timestamp!tsrequest;
       ts: timestampentry;
       fileMTime: unix!long;
     begin
       receive args from q;
       block begin
          -- check if the file exists in the cache
          ts := tscache[args.name];
          args.result <- ts.timestamp;
       on (notfound)
          -- doesn't exists is cache so retrive its timestamp and update cache
          new ts;
          ts.name := args.name;
          if not access(args.name, access#'exists') 
          then -- object doesn't exist
              args.result <- -1;
              ts.timestamp := -1;
          else
              fileMTime <- stat(args.name); 
              args.result := fileMTime;
              ts.timestamp <- fileMTime;
          end if;
          insert ts into tscache;
       end block;
     return args;
     end block;
   end while;
-- if stat cannot find file, it returns -1.  This should be checked for
-- in this code!!!

end process

