-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: Make.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)make.p	1.3 3/13/90"

make: using(make, worklist)
	process(makeQ: makeQ)
declare
  makeM: MakeIntf;
  graph: dependencyGraph;
  worklist: worklist;
  node: node;
  prednode: node;
  succnode: node;
  successors: charstringSet;
  predecessors: charstringSet;
  action: ActionFunc;
  mustMake: boolean;
  makeError: boolean;
  status: status;
  name: charstring;
  ReadyToMake: charstringSet;  -- are those nodes of the graph that have no
	       -- predecessors or all predecessors have already been made
  nodeinfo: nodeinfo;
  NotReadyToMake: nodeinfoset;  -- are pairs <name, unmadepred> of those nodes
	       -- in graph who cannot yet be made because unmadepred number of
	       -- predecessors have not yet been made
  leaf: charstring;
  leaves: charstringSet;
  nonleaf: nodeinfo;
  nonleaves: nodeinfoset;

  dummyQ: ActionQ;
  dummyAction: actionFunc;

begin
  receive makeM from makeQ;
  makeError := 'false';

-- a "dummy action" is needed when getdependencies for a node fails.  Its
-- action becomes the dummy action.  
  new dummyQ;
  connect dummyAction to dummyQ;

-- initialize data structures
  new graph;
  new ReadyToMake;
  new NotReadyToMake;
  new nodeinfo;

-- initialize worklist with root objects
  new worklist;
  for rootname in makeM.root where ('true')
  inspect
     new node;
     node.name := rootname;
     new node.successors;
     insert node into worklist;  
  end for;

------------------------------------------------------------------
-------------------------  Graph building ------------------------
------------------------------------------------------------------
-- builds graph. also constructs ReadyToMake & NotReadyToMake sets.

  while size of worklist > 0 repeat
      remove node from n in worklist where('true');  -- get any node
-- print charstring#"make: removing"; print node.name; print charstring#" from worklist  ";
      block begin
 	call MakeM.getDependencies(node.name,predecessors,action,mustMake); 
	if size of predecessors = 0 
	then insert copy of node.name into ReadyToMake;
	else 
	    new nodeinfo;
	    nodeinfo.name := copy of node.name;
	    nodeinfo.unmadepred := size of predecessors;
	    insert nodeinfo into NotReadyToMake;
	end if;
	for pred in predecessors where('true')
	inspect
-- 3 cases can occur: either (1) a node named pred already exists in the graph,
-- or (2) it already exists in the worklist, or (3) it needs to
-- be created to & added to the work list.  In any case, node.name needs
-- to be added to the successor field of the node named pred.  
           block begin
	     remove prednode from n in graph where(n.name = pred);
	     insert copy of(node.name) into prednode.successors;
	     insert prednode into graph;
	   on (notfound)
	      block begin
	        remove prednode from n in worklist where(n.name=pred); 
	        insert copy of(node.name) into prednode.successors;
                insert prednode into worklist;
	      on (notfound)
		new prednode;
	     	prednode.name := copy of pred;
                new prednode.successors;
		insert copy of(node.name) into prednode.successors;
	        insert prednode into worklist;
	      end block;
	   end block;
	end for;
-- finish creating the node and add it to the graph
	node.action <- action;
	node.mustMake <- mustMake;
	node.status <- 'DependenciesSuccess';

      on (GetDependenciesIntf.dependencyFailure)
	node.action := dummyAction;
	node.mustMake <- 'false';
	node.status <- 'DependenciesFailure';
	insert copy of node.name into ReadyToMake;
	if makeM.ErrorControl = 'Stop'
	then exit notmade;
	else makeError:= 'true';
	end if;
      end block;
      insert node into graph;
  end while;

------------------------------------------------------------------
-------------------------  Cycle Testing -------------------------
------------------------------------------------------------------
-- This section of code checks (by topologically
-- sorting graph) for a cycle and raises the appropriate exception if
-- a cycle is found.  
--
  leaves <- copy of ReadyToMake;
  nonleaves <- copy of NotReadyToMake;
  while size of leaves > 0 repeat
    remove leaf from l in leaves where('true');
    inspect g_node in graph where(g_node.name = leaf)
    begin
      for s in g_node.successors where('true')
      inspect
        remove nonleaf from nl in nonleaves where(nl.name = s);
        nonleaf.unmadepred <- nonleaf.unmadepred - 1;
        if nonleaf.unmadepred = 0 
        then insert nonleaf.name into leaves;
        else insert nonleaf into nonleaves;
        end if;
      end for;
    end inspect;
  end while;

  if size of nonleaves > 0 
  then exit cycle;
  end if;

------------------------------------------------------------------
-----------------------  Making the graph ------------------------
------------------------------------------------------------------

  if makeM.actionControl = 'None'  -- do not process graph
  then 
	if makeError then exit notmade; else exit normal; end if;
  end if;
 
  while size of ReadyToMake > 0 repeat
-- take a node off of the ReadyToMake set and make it (if can).  
     remove name from  cs in ReadyToMake where('true');
     remove node from n in graph where(n.name = name);
     if (node.status = 'DependenciesSuccess') and
        (node.mustMake or makeM.ActionControl = 'All')
     then
	if node.action()       -- make node. if successful then:
	then node.status <- 'ActionSuccess';
	else
	   node.status <- 'ActionFailure';
           if makeM.ErrorControl = 'Stop'
	   then exit notmade;
	   else makeError:= 'true';
	   end if;
        end if;
     end if;
-- if node is in one of the two success states or control dictates to 
-- make even error paths, update
-- successors and put onto ReadyToMake if they are now ready.  
-- also update mustMake field of successors in graph
     if (makeM.ActionControl = 'All') or
        (node.status = 'DependenciesSuccess') or
        (node.status = 'ActionSuccess') 
     then
	for node_name in node.successors where('true')
	inspect
	   remove nodeinfo from np in NotReadyToMake where(np.name = node_name);
	   nodeinfo.unmadepred := nodeinfo.unmadepred - 1;
	   if nodeinfo.unmadepred = 0
	   then
		insert nodeinfo.name into ReadyToMake;
	   else
		insert nodeinfo into NotReadyToMake;
	   end if;
	   if node.mustMake  -- if node was made then successor must be made
	   then  
		remove succnode from n in graph where(n.name = node_name);
		succnode.mustMake <- 'true';
		insert succnode into graph;   -- put succnode back into graph
	   end if;
	end for;
     end if;
     insert node into graph;  --put node back into graph
  end while;

  if makeError then exit notmade; else exit normal; end if; 

------------------------------------------------------------------
----------------------  return call message ----------------------
------------------------------------------------------------------

  on exit(normal)
     makeM.graph <- graph;
     return makeM;
  on exit(notmade)
     makeM.graph <- graph;
     return makeM exception NotMade;
  on exit(cycle)
     makeM.graph <- graph;
     return makeM exception Circular;
end process
