-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: initcheckscope.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)initcheckscope.p	1.2 3/13/90"
-- description:
-- initcheckscope is given some capabilities and returns the checkscope 
-- function. The checkscope function is given a path prefix and returns 'true'
-- if the path is in MKSCOPE and false otherwise.  
initcheckscope: using(checkscope,common,root)
process (q: initcheckscopeq)

declare
  cm: initcheckscopeIntf;
  enventry: root!enventry;
  path: charstring;
  mkScope: common!charstringList;  -- set of path prefixes corresponding to
  char: char;
  pos: integer;
  directory: charstring;

  checkscopeq: checkscope!checkscopeq;
  checkscopeFn: checkscope!checkscopeFn;

begin

  receive cm from q;
  
-- convert the unix-style MKSCOPE path variable into a charstringList mkscope
  block begin
    enventry <- var in cm.environ where (var.variable = "MKSCOPE");
    path <- enventry.value;
  on (NotFound)
-- if not found then path is taken to be the current working dir
    path := cm.cwd;
  end block;

  pos <- 0; directory <- "";
  new mkScope;
  while pos < size of path repeat
     char := path[pos];
     if char = ':' then 
         if directory <> "" 
         then 
            if directory <> "." 
              then insert directory into mkScope; 
               -- else substitute the cwd for "."
              else insert copy of cm.cwd into mkScope; 
            end if;
            directory <- "";
         end if;
     else insert char into directory;
     end if;
     pos <- pos + 1;
  end while;

  if directory <> "" 
  then 
      if directory <> "." 
        then insert directory into mkScope; 
         -- else substitute the cwd for "."
        else insert copy of cm.cwd into mkScope; 
      end if;
  end if;

-- now we have constructed mkScope, return the outport to the checkscope func
  new checkscopeq;
  connect cm.checkscope to checkscopeq;
  return cm;
  discard q;

-- forever process requests
  while 'true' repeat
    block
    declare
      checkM: checkscopeIntf;
    begin
      receive checkM from checkscopeq;
      if exists of p in mkScope where (p =  checkM.path)
      then 
         checkM.result <- 'true';
      else 
         checkM.result <- 'false';
      end if;
      return checkM;
    end block;
  end while;
end process
