-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: getNextUse.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)getnextuse.p	1.4 3/13/90"
-- getNextUse(line:charstring, pos:integer) returns the token that begins
-- at line[pos] and is terminated by the next occurence of a comma, a 
-- space, a left paren '(', a right paren ')', or a 'NL'.  It advances pos to 
-- point to the terminating char (a comma, a right paren,  etc.)

getnextuse: using(predefined, getuses)
process(getQ:getNextUseQ)

declare
getM: getNextUseIntf;
c: char;

begin
block begin
receive getM from getQ;
new getM.substring;
c := char in getM.string where(position of char = getM.pos);
insert c into getM.substring;

getM.pos <- getM.pos + 1;
c := char in getM.string where(position of char = getM.pos);
while (c <> '(') and (c <> ')') and (c <> ',') and (c<>' ') and (c <> 'NL') repeat
   insert c into getM.substring;
   getM.pos <- getM.pos + 1;
   c := char in getM.string where(position of char = getM.pos);
end while;
return getM;

on (notfound)
   return getM exception noUse;      
end block;
end process
