-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: getdep.d
-- Author: Daniel Yellin
-- SCCS Info: "@(#)getdep.d	1.2 3/13/90"

getdep: using(predefined,common,root,stdenv,unix,terminalio,cload,
              findfile,make)
definitions

actionType: enumeration('print', 'compile');

ActionInitIntf: callmessage (
   environ: root!environ,
   std: stdenv!stdenv,
   unix: unix!unix,
   CLoader: CLoad!CLoadFn,
   name: charstring,              -- name of node to be made
   action: make!ActionFunc        -- the action to make this node
) constant(environ,std,unix,CLoader,name)
  exit { full };
ActionInitQ: inport of ActionInitIntf {full(environ),full(std),full(unix),
                                       full(CLoader),full(name)};
ActionInitFn: outport of ActionInitQ;

-- setupGetDepFunc returns the getDependency function (see make.d). 
setupGetDepIntf: callmessage (
   environ: root!environ,
   std: stdenv!stdenv,
   unix: unix!unix,
   CLoader: CLoad!CLoadFn,
   actionType: actionType,
   getdepFunc: GetDependenciesFunc
  ) constant (environ,std,unix,CLoader,actionType)
    exit { full };   
setupGetDepQ: inport of setupGetDepIntf {full(environ),full(std),full(unix),
                     full(CLoader),full(actionType)};
setupGetDepService: outport of setupGetDepQ;

setupActionIntf: callmessage(
   std:stdenv!stdenv,
   ActionFunc: ActionFunc
) constant(std)
  exit {full};
setupActionQueue: inport of setupActionIntf {full(std)};
setupActionProcess: outport of setupActionQueue;

end definitions
