-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: linkserver.p
-- Author: Andy Lowry
-- SCCS Info: @(#)linkserver.p	1.2 3/13/90

-- This process takes a resource manager in its init message and then
-- sets up to receive link requests from remote interpreters.  Each
-- time a request comes in, a copy of the resource manager is passed
-- back.

linkServer: using (linkServer, distributed, sysRManager)

process (initQ: linkServerQ)
  
declare
  initArgs: linkServer;
  sysRM: sysRManager;
  linkQ: genericQ;
  linkFn: genericFn;
  linkArgs: generic;
begin
  receive initArgs from initQ;

  -- create the link service ports
  new linkQ;
  connect linkFn to linkQ;
  
  -- install link capability in net services
  call initArgs.setLink(linkFn);
  
  -- copy the resource manager we'll be handing out
  sysRM := initArgs.sysRM;
  
  -- return the init message and start servicing link requests
  return initArgs;
  discard initQ;
  
  while 'true' repeat
    receive linkArgs from linkQ;
    wrap copy of sysRM as linkArgs.value;
    return linkArgs;
  end while;
  
end process
