-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
optimize: using (predefined,cgInternal,optimize)

process (Q: optimizeQ)
  
declare
  args: optimize;
  lookup: EmptyBBRemoval;
  tight: EmptyBBRemoval;
  a_b: BBidSubstitution;
  newbbs: basicBlocks;
  neworder: BBidList;
  bb: basicBlock;
  removed: BBidBag;
  bbstack: BBidList;
  generated: BBidBag;
  nextbb: BBid;
begin
  receive args from Q;

  -- figure out which blocks can be replaced by which blocks
  new lookup;
  new removed;
  for b in args.BBData.BBs 
	 where
	 (boolean#(boolean#(integer#0 = integer#(size of b.code))
		 and boolean#(BBExitType#(case of b.exit)
		     =BBExitType#'jump')))
    inspect
      insert BBid#(copy of b.id) into removed;
      block
	declare
	  replacement: BBidSubstitution;
	begin
	  reveal b.exit.jump;
	  remove replacement 
	     from lookup[b.exit.jump];
	  insert BBid#(copy of b.id) into replacement.old;
	  insert replacement into lookup;
	on (NotFound)
	  new replacement;
	  new replacement.old;
	  insert BBid#(copy of b.id) into replacement.old;
	  replacement.new := b.exit.jump;
	  insert replacement into lookup;
	end block;
    end for;	      
  -- print lookup;

  -- tighten the lookup table by <a b>^<b c> -> <a c>
  new tight;
  while (boolean#(exists of lookup[]))
    repeat
      remove a_b from lookup[];
      -- print a_b;
      block
	declare
	  b_c: BBidSubstitution;
	begin
	  remove b_c from map in lookup
	     where (boolean#(exists of map.old[a_b.new]));
	  merge a_b.old into b_c.old;
	  insert b_c into lookup;
	on (NotFound)
	  block 
	    declare
	      final: BBidSubstitution;
	    begin
	      remove final 
		 from map in tight
		 where (boolean#(exists of map.old[a_b.new]));
	      merge a_b.old into final.old;
	      insert final into tight;
	    on (NotFound)
	      insert a_b into tight;
	    end block;
	end block;
    end while;
  -- print charstring#"Tight";
  -- print tight;
  
  -- Apply the tight remapping to all the basic blocks
  new newbbs;
  for bbTemp in args.BBData.bbs
	 where (boolean#(not boolean#(exists of removed[bbTemp.id])))
    inspect
      bb := bbTemp;
      -- print bb;
      -- apply tight to bb
      select (BBExitType#(case of bb.exit))
	where (BBExitType#'jump')
	  reveal bb.exit.jump;
	  if (boolean#(exists of removed[bb.exit.jump])) then
	      inspect map in tight 
		     where (boolean#(exists of map.old[bb.exit.jump]))
		begin
		  bb.exit.jump := map.new;
		end inspect;
	    end if;
	where (BBExitType#'ifelse')
	  reveal bb.exit.ifelse;
	  if (boolean#(exists of removed[bb.exit.ifelse.ifTarget])) then
	      inspect map in tight 
		     where (boolean#
			 (exists of map.old[bb.exit.ifelse.ifTarget]))
		begin
		  bb.exit.ifelse.ifTarget := map.new;
		end inspect;
	    end if;
	  if (boolean#(exists of removed[bb.exit.ifelse.elseTarget])) then
	      inspect map in tight 
		     where (boolean#
			 (exists of map.old[bb.exit.ifelse.elseTarget]))
		begin
		  bb.exit.ifelse.elseTarget := map.new;
		end inspect;
	    end if;
	where (BBExitType#'select')
	  reveal bb.exit.selection;
	  if (boolean#(exists of removed[bb.exit.selection.other])) then
	      inspect map in tight 
		     where (boolean#
			 (exists of map.old[bb.exit.selection.other]))
		begin
		  bb.exit.selection.other := map.new;
		end inspect;
	    end if;
	  block
	    declare
	      newtargets: BBidList;
	    begin
	      new newtargets;
	      for target in bb.exit.selection.targets[] inspect
		  if (boolean#(exists of removed[target])) 
		    then
		      inspect map in tight 
			     where (boolean#(exists of map.old[target]))
			begin
			  insert BBid#(copy of map.new) into newtargets 
			     at integer#(position of target);
			end inspect;
		    else
		      insert target into newtargets 
			 at integer#(position of target);
		    end if;
		end for;
	      bb.exit.selection.targets <- newtargets;
	    end block;
	where (BBExitType#'test')
	  reveal bb.exit.test;
	  if (boolean#(exists of removed[bb.exit.test.nojump])) then
	      inspect map in tight 
		     where (boolean#
			 (exists of map.old[bb.exit.test.nojump]))
		begin
		  bb.exit.test.nojump := map.new;
		end inspect;
	    end if;
	  if (boolean#(exists of removed[bb.exit.test.jump])) then
	      inspect map in tight 
		     where (boolean#
			 (exists of map.old[bb.exit.test.jump]))
		begin
		  bb.exit.test.jump := map.new;
		end inspect;
	    end if;
	where (BBExitType#'handlers')
	  reveal bb.exit.handlers;
	  if (boolean#(exists of removed[bb.exit.handlers.entry])) then
	      inspect map in tight 
		     where (boolean#
			 (exists of map.old[bb.exit.handlers.entry]))
		begin
		  bb.exit.handlers.entry := map.new;
		end inspect;
	    end if;
	  block
	    declare
	      newtargets: BBidList;
	    begin
	      new newtargets;
	      for target in bb.exit.handlers.targets[] inspect
		  if (boolean#(exists of removed[target])) 
		    then
		      inspect map in tight 
			     where (boolean#(exists of map.old[target]))
			begin
			  insert BBid#(copy of map.new) into newtargets 
			     at integer#(position of target);
			end inspect;
		    else
		      insert target into newtargets 
			 at integer#(position of target);
		    end if;
		end for;
	      bb.exit.handlers.targets <- newtargets;
	    end block;
	otherwise
	end select;
      insert bb into newbbs;
    end for;
  
  args.BBData.BBs <- newbbs;
  if (boolean#(exists of removed[args.BBData.entry])) then
      inspect map in tight 
	     where (boolean#
		 (exists of map.old[args.BBData.entry]))
	begin
	  args.BBData.entry := map.new;
	end inspect;
    end if;
  
  -- Here is where i will optimize the bb order
  -- For now i just do a trivial flow graph traversal
  new neworder;
  new bbstack;
  new generated;
  insert BBid#(copy of args.BBData.entry) into bbstack at integer#0;
  while (boolean#(exists of bbstack[]))
    repeat
      remove nextbb from bbstack[integer#0];
      if (boolean#(exists of generated[nextbb]))
	then
	  -- No need to output it, it already has been
	else
	  -- Output bb to neworder
	  insert BBid#(copy of nextbb)
	     into neworder at (integer#(size of neworder));
	  insert BBid#(copy of nextbb) into generated;
	  -- Add the predecessors to the stack
	  inspect currentbb in args.BBData.BBs[nextbb]
	    begin
	      select (BBExitType#(case of currentbb.exit))
		where (BBExitType#'jump')
		  reveal currentbb.exit.jump;
		  insert BBid#(copy of currentbb.exit.jump)
		     into bbstack at integer#0;
		where (BBExitType#'ifelse')
		  reveal currentbb.exit.ifelse;
		  insert BBid#(copy of currentbb.exit.ifelse.elseTarget)
		     into bbstack at integer#0;
		  insert BBid#(copy of currentbb.exit.ifelse.ifTarget)
		     into bbstack at integer#0;
		where (BBExitType#'select')
		  reveal currentbb.exit.selection;
		  merge BBidList#(copy of currentbb.exit.selection.targets)
		     into bbstack at integer#0;
		  insert BBid#(copy of currentbb.exit.selection.other) 
		     into bbstack at integer#0;
		where (BBExitType#'test')
		  reveal currentbb.exit.test;
		  insert BBid#(copy of currentbb.exit.test.nojump)
		     into bbstack at integer#0;
		  insert BBid#(copy of currentbb.exit.test.jump)
		     into bbstack at integer#0;
		where (BBExitType#'handlers')
		  reveal currentbb.exit.handlers;
		  merge BBidList#(copy of currentbb.exit.handlers.targets)
		     into bbstack at integer#0;
		  insert BBid#(copy of currentbb.exit.handlers.entry) 
		     into bbstack at integer#0;
		otherwise
		end select;
	    end inspect;
	end if;
    end while;
  args.BBData.BBOrder <- neworder;

  return args;
end process
 
