-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)load.d	1.2 3/13/90

-- defines the interface used to load process modules dynamically.  user
-- supplies a program name string, receives a program.

load: using (predefined)
definitions

  load_intf: callmessage (
    modulename: charstring,	-- hermes internal name of module to load
    program: program		-- its "compiled" program
  ) constant (modulename)
    exit { full }
    exception file_not_found { init(modulename) };

  load_q: inport of load_intf { init(modulename) };

  load_func: outport of load_q;


  storeIntf: callmessage (
    modulename: charstring,
    program: program
  ) constant (modulename, program)
    exit { full }
    exception cantStoreProgram { full };

  storeQ: inport of storeIntf { full };

  storeFunc: outport of storeQ;

end definitions
