-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: codegen.d
-- Author: Andy Lowry
-- SCCS Info: @(#)codegen.d	1.10 3/13/90

-- This is the interface to the code generator.  Input consists of an
-- absprog object and a table of "annotations" pertaining to the
-- program.  Some annotations, such as infferred types, might be
-- required by the code generator.  Others, such as root object print
-- names, source text, etc., can help the code generator produce more
-- helpful error messages or more readable assembly source.

-- The 'options' table provides a mechanism for turning on or off
-- various options in the codegen, such as certain types of
-- optimization or the production of assembly source code.

-- A couple of capabilities to processes that load Hermes objects from
-- disk are also required.

-- The output of the code generator is not visible in its interface,
-- since it is returned in a "hidden" field of the absprog itself.
-- Since this alteration of the absprog is completely hidden, it is
-- left out of the inteface altogether, to the extent that the
-- absprog is declared constant!

codegen: using (load, stdenv, unix, annotate)

definitions

  codegen: callmessage (
      absprog: program,		-- program to compile
      annotations: annotations,	-- auxiliary info attached to absprog
      options: annotations,	-- codegen option specs
      std: stdenv,		-- standard hermes capas
      stdio: unix!stdio		-- additional IO routines
    )
				-- absprog not really constant, see above
    constant (absprog, annotations, options, std, stdio)
    exit {full};
  codegenQ: inport of codegen {full};
  codegenFn: outport of codegenQ;

end definitions
