/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)listp.h	1.3 3/13/90 */

#ifndef listp_included

typedef union
{
  struct cons_struct *struct_ptr;
  
  int intval;
  
  struct oplist_struct *op_lst_p_val;

} car_cell;



typedef struct cons_struct
{
  struct cons_struct *next;
  
  car_cell data;
  
} cell;



#define car(x)               car_f((x))
#define cdr(x)               ((x)->next)
#define last(x)              last_f((cell *) x)
#define cons(atom,list)      cons_f((atom),(list))
#define append(l1,l2)	     append_f((cell *)(l1), (cell *)(l2))
#define	foreach_list(ptr)    for(; (ptr) isnt nil; (ptr) = cdr((ptr)))
#define	dispose_list(ptr, type)  foreach ((ptr)) dispose ((ptr),(type))


#define car_f(x)             (((cell *)(x))->data)

#define cons_f(atom,list)    (constemp = new(cell), \
			      car(constemp) = (atom), \
			      cdr(constemp) = (list), \
			      constemp)
cell *constemp;

cell *append_f();
cell *last_f();

#endif
#define listp_included
