/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#define HERMESPROG ((u_long) 0x22847A63)
				/* something not likely to conflict */
#define HERMESPROC ((u_long) 1)
#define HERMESTIMEOUT 7
#define LINKPORTADDR 0

typedef enum {
    hmsg_noop,			/* () */
    hmsg_call,			/* (callmsg_valcell) */
    hmsg_return,		/* (callmsg_valcell) */
    hmsg_return_error,		/* (callmsg_remaddr, predef_exception) */
    hmsg_return_discarded,	/* (callmsg_valcell) */
    hmsg_return_exception,	/* (callmsg_valcell, excepname_valcell) */
    hmsg_send,			/* (channel_remaddr, obj_valcell, pcb_addr) */
    hmsg_send_ok,		/* (pcb_addr) */
    hmsg_send_error,		/* (pcb_addr, predef_exception) */
    hmsg_adjust			/* (channel_remaddr, adjustment_integer) */

} hmsg_command;

typedef struct {
    valcell callmessage;
    valcell excep;
} hmsg_return_excep;

typedef struct {
    valcell callmessage;
    predef_exception excep;
} hmsg_return_err;


typedef union {
    valcell callmsg;		/* call: the callmessage itself (with SASE) */
				/* return_discarded */
				/* return */

    object sendmsg;		/* send: or the message of a send */

    int adjustment;		/* adjust: adjustment value */

    hmsg_return_excep excepmsg; /* return_exception */

    hmsg_return_err errormsg;	/* return_error */

} hmbuf_union;


typedef struct {

    remaddr addr;		/* address in target interpreter */

    interpname sender;		/* for back-pinging if necessary */

    hmsg_command command;	/* operation to perform */

    hmbuf_union mbuf;		/* parameters */

} hmsg_buf;

