-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)putstring.p	1.2 3/13/90

putString: using (predefined, terminalIO, terminalInits, unix)
process (initQ: initPutStringQ)

declare
  init: initPutStringIntf;
  fputs: fputs_function;
  file: handle;
  putStringQ: putStringQ;
  putString: putStringIntf;

begin
  receive init from initQ;
  fputs := init.fputs;
  file := init.file;
  new putStringQ;
  connect init.putString to putStringQ;
  return init;

  while boolean#'true' repeat
    receive putString from putStringQ;
    if boolean#(int#(fputs(putString.string, file)) >= int#0) then
      return putString;
    else
      discard putString;
    end if;
  end while;
end process
