-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)getfile.p	1.7 3/13/90

getfile: using (getfile, unix) process (initQ: getFileInitQ)

declare
  init: getFileInit;
  q: getFileQ;

  array: unix!array;
  fopen: unix!fopen_function;
  fclose: unix!fclose_function;
  fread: unix!fread_function;

begin
  receive init from initQ;
  fopen := init.fopen;
  fread := init.fread;
  fclose := init.fclose;
  new q;
  connect init.getFile to q;
  return init;

-- service loop

  while boolean#'true' repeat block 
    declare
      getFile: getFile;
      handle: unix!handle;
      nread: unix!int;
    begin
      block begin
	receive getFile from q;
      on (disconnected)
	exit done;
      end block;
      handle := handle#( fopen(charstring#(copy of getFile.name),
	  charstring#"r") );
      if boolean#( handle = handle#0 ) then 
        exit cantRead;
      end if;

      new array;
      array.string := charstring#"";
      array.size := int#1;
      array.count := int#0;
      nread := int#( fread(array, handle) );
      getFile.file <- array.string;

      call fclose(handle);
      return getFile;

    on exit (cantRead)
      return getFile exception cantRead;
    on exit(done)
      exit done;
    on (others)
      discard getFile;
    end block;
  end while;

on exit(done)
end process
