-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: checkdefs.p
-- Author: David F. Bacon
-- SCCS Info: @(#)checkdefs.p	1.2 3/13/90

checkDefs: using (checkDefs, errors, positions) process (q: checkDefsQ)
    
  declare
    args: checkDefs;
    error: error;
    errorTemplate: error;
    errObj: errorObject;
    
  begin
    receive args from q;
    
    new args.errors;

    new errorTemplate;
    errorTemplate.code := 'general error';
    unite errorTemplate.position.apos from evaluate pos: aposition from
	new pos; pos.clause := unique; pos.statement := unique; end;
    new errorTemplate.objects;
    
    inspect module in args.defs[args.id] begin
	for typedef in module.type_definitions[] inspect
	    select case of typedef.specification

	      where ('outporttype')
		reveal typedef.specification.outport_info;
		inspect defmod in args.defs[typedef.specification.outport_info.moduleid]
		  begin
		    inspect inportdef in defmod.type_definitions[typedef.specification.outport_info.typeid]
		      begin
			if case of inportdef.specification <> 'inporttype' then
			    error := errorTemplate;
			    unite errObj.charstring from 
			        "outport of non-inport";
			    insert errObj into error.objects;
			    insert error into args.errors;

			  end if;
		      end inspect;
		  end inspect;
		
	      where ('varianttype')
		reveal typedef.specification.variant_info;
		inspect defmod in args.defs[typedef.specification.variant_info.case_type.moduleid]
		  begin
		    inspect enumdef in defmod.type_definitions[typedef.specification.variant_info.case_type.typeid]
		      begin
			if case of enumdef.specification <> 'enumerationtype' 
			  then
			    error := errorTemplate;
			    unite errObj.charstring from 
			        "variant of non-enumeration type";
			    insert errObj into error.objects;
			    insert error into args.errors;
			  else
			    reveal enumdef.specification.enumeration;
			    if size of enumdef.specification.enumeration.values
				   <> size of typedef.component_declarations then
				error := errorTemplate;
				unite errObj.charstring from 
			            "variant is missing cases";
				insert errObj into error.objects;
				insert error into args.errors;
			      else
				-- it's an enumeration of the right size; match up the
				-- components one by one.
				-- or do we actually ever have to do this??  maybe not
			      end if;
			  end if;
		      end inspect;
		  end inspect;
		
	      otherwise
	      end select;
	  end for;
      end inspect;
    
    return args;
  end process
   
