-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)fmtts.p	1.3 3/13/90

FmtTS : USING(AbsFormat)
PROCESS (FormatTypestateInit : FormatTypestateInport )
-- procedure to format a typestate
-- algorithm:  format as:
--   "{" comma-separated list of attributes "}"
  DECLARE
    FP: FormatTypestateCall ;
    first_element_written: boolean;
  BEGIN
    RECEIVE FP FROM FormatTypestateInit;
    FP.FormatValue <- "{";
    first_element_written <- 'false';
    FOR Attribute IN FP.Typestate WHERE('true')
      INSPECT
        IF first_element_written
          THEN
            INSERT ',' INTO FP.FormatValue;
          ELSE
            first_element_written <- 'true';
          END IF;
        MERGE FP.Formatters.FormatAttribute(FP.Formatters, FP.Definitions, FP.Declarations, FP.InferredDeclarations, FP.DefinitionsMap, FP.ExecutableMap, Attribute) INTO FP.FormatValue;
      END FOR;
    INSERT '}' INTO FP.FormatValue;
    RETURN FP;
  END PROCESS
