/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)unqualname.ch	1.3 3/13/90 */

#include "cherm.h"

#include "resolve.h"
#include "lex-yacc.h"

#include "unqualname.cd"
#include "errors.cd"

hobject(Unqualnames,table);	/* unqualname!unqualnames: table of */
				/*  unqualified names that have bee+q used */
				/*  so far in the current definitions module */


void
add_unqualname(name, istype)
char *name;			/* constant string: name that */
				/*   was used without a qualifier. */
flag istype;			/* constant flag: true if type, false */
				/*  if attribute. */
{
    extern globinfo global;	/* contains positions in source file */

    lobject(Unqual);		/* unqualname!unqual: unqualified name and */
				/*  line number of its occurrence. */


    new_record(Unqual, unqual);
    h_boolean(Unqual@unqual__istype, istype);
    chs_lit(Unqual@unqual__name, name);
    ilit(Unqual@unqual__line, global.lineno);
    if (insert(Unqualnames, Unqual) isnt Normal) 
      discard(Unqual);
}


void
check_unqualname(name, istype)
char *name;			/* constant string: name to check */
				/*  whether it was used without qualifier. */
flag istype;			/* constant flag: true if a type name. */
{
    lobject(Unqualrec);
    lobject(Typename);
    lobject(Boolval);

    h_boolean(Boolval, istype);
    chs_lit(Typename, name);
    if (h_lookup(Unqualrec, Unqualnames, Typename, Boolval) is Normal) {
				/* name was used */
	fe_error(LASTPHASE,  errorcode__general_error,
		 "Name '%s' used at line %d is defined locally and in an imported module.  Reference must be qualified with a module name", 
		 stringval(Unqualrec@unqual__name), 
		 integerval(Unqualrec@unqual__line));
    }
    discard(Typename);
}
	

void
init_unqualnames()
{
    avl_new_table(Unqualnames, firstandthird_key);
}

void
end_unqualnames()
{
    discard(Unqualnames);
}
