/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: standalone.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)standalone.ch	1.13 4/20/90";
#endif

#include <string.h>
#include <stdio.h>
#include <sys/file.h>

#include "cherm.h"
#include "resolve.h"
#include "storage.h"

#include "unixenv.h"

#include "predefined.cd"
#include "filedef.cd"
#include "errors.cd"

flag integrated = FALSE;


main(argc, argv)
int argc;
char *argv[];
{
    femain(argc, argv);
}


objectp
io_read_definition(Name)
objectp Name;			/* constant chs_table */
{
    char *hermpath();

    hobject(SFilename,chs_table);
    objectp Filedef;		/* filed_definition */
    char *pathfile;


    pathfile = hermpath(stringval(Name), DEF_OBJECT_EXTENSION);
    if (pathfile is nil) {
	fe_error(LASTPHASE, errorcode__general_error,
		 "Can't find file %s%s -- check your path",
		 stringval(Name), DEF_OBJECT_EXTENSION);
	return(nil);
    }

    chs_lit(SFilename, pathfile);

    Filedef = new_object();
    if (read(Filedef, SFilename) isnt Normal) {
				/* read in the module.  if error reading... */

	fe_error(LASTPHASE, errorcode__general_error,
		"Can't read compiled definition of '%s' from file '%s'",
		 stringval(Name), stringval(SFilename));

	return(nil);
    }

    return(Filedef);
}


void
io_write_definition(modulename, Moduleid, Defs, Printmaps, Procmaps, Modmap)
char *modulename;
objectp Moduleid;		/* constant */
objectp Defs;
objectp Printmaps;
objectp Procmaps;
objectp Modmap;
{
    lobject(SFiledef);		/* filed_definition */
    lobject(SFilenameo);	/* charstring */
    lobject(SSuffix);		/* charstring */
    lobject(Def);		/* definitions_module */
    lobject(Printmap);		/* definitions_printmap */

    h_lookup(Def, Defs, Moduleid, 0);
    h_lookup(Printmap, Printmaps, Moduleid, 0);

    new_record(SFiledef, filed_definition);
    fremove(SFiledef@filed_definition__definitions_module, Def, Defs,
	    PRIMARY_KEY);
    fremove(SFiledef@filed_definition__defmap, Printmap, Printmaps,
	    PRIMARY_KEY);
    move(SFiledef@filed_definition__procmaps, Procmaps);
    move(SFiledef@filed_definition__direct_imports, Modmap);

    chs_lit(SSuffix, DEF_OBJECT_EXTENSION);
    chs_lit(SFilenameo, modulename);
    merge(SFilenameo, SSuffix);

    if (write(SFiledef, SFilenameo) isnt Normal)
      fe_error(LASTPHASE, errorcode__general_error,
	       "Can't write compiled definition module '%s' to file '%s'",
	       modulename, stringval(SFilenameo));
}



objectp
io_read_proc(Name)
objectp Name;			/* constant chs_table */
{
  char *linkpath();

  hobject(SFilename, chs_table);
  objectp Fileproc;		/* filed_proces */
  char *pathfile;
  
  pathfile = linkpath(stringval(Name), PROC_OBJECT_EXTENSION);
  if (pathfile is nil) {
    fe_error(LASTPHASE, errorcode__general_error,
	     "Can't find file %s%s -- check your path",
	     stringval(Name), PROC_OBJECT_EXTENSION);
    return(nil);
  }
  chs_lit(SFilename, pathfile);

  Fileproc = new_object();
  if (read(Fileproc, SFilename) isnt Normal) {
				/* read in the module. if error reading... */
    fe_error(LASTPHASE, errorcode__general_error,
	     "Can't read compiled process '%s' from file '%s'",
	     stringval(Name), stringval(SFilename));
    return(nil);
  }

  return(Fileproc);
}

void
io_write_proc(modulename, Absprog, Defmaps, Printmaps, Posmaps, Modmap, Links)
char *modulename;
objectp Absprog;
objectp Defmaps;
objectp Printmaps;
objectp Posmaps;
objectp Modmap;
objectp Links;
{
    lobject(SFileproc);		/* filed_process */
    lobject(SPofilename);	/* charstring */
    lobject(SPosuffix);		/* charstring */


    new_record(SFileproc, filed_process);

    move(SFileproc@filed_process__main_program, Absprog@program__main_program);
    move(SFileproc@filed_process__programs, Absprog@program__programs);
    move(SFileproc@filed_process__procmaps, Printmaps);
    move(SFileproc@filed_process__direct_imports, Modmap);
    move(SFileproc@filed_process__links, Links);
    move(SFileproc@filed_process__posmaps, Posmaps);

    chs_lit(SPofilename, modulename);
    chs_lit(SPosuffix, ABSPROG_OBJECT_EXTENSION);
    merge(SPofilename, SPosuffix);

    if (write(SFileproc, SPofilename) isnt Normal)
      fe_error(LASTPHASE, errorcode__general_error,
	       "Can't write compiled process module '%s' to file '%s'",
	       modulename, stringval(SPofilename));
}


static char *
hermpath(file, suffix)
char *file;
char *suffix;
{
    char *pathfind();
    char *getenv();
    char *hrootdir();

    char *path;
    char *pathx = nil;
    char *root;
    char *fullfile;


    fullfile = (char *) getmain(strlen(file) + strlen(suffix) + 1);
    if (fullfile is nil)
      return(nil);
    strcat(strcpy(fullfile, file), suffix);

    if ((path = getenv(PATH_VARNAME)) is nil) {
      /* no path: use system default */
      root = hrootdir();
      pathx = path = (char *) getmain(strlen(".:") + strlen(root) +
					  strlen("/bin") + 1);
      if (path isnt nil)
	strcat(strcat(strcpy(path, ".:"), root), "/bin");
    }
    if (path isnt nil)
      path = pathfind(path, fullfile, R_OK);
    freemain(fullfile,strlen(fullfile)+1);
    if (pathx isnt nil)
      freemain(pathx,strlen(pathx)+1);
    return path;
}

static char *
linkpath(file, suffix)
char *file;
char *suffix;
{
    char *pathfind();
    char *getenv();
    char *hrootdir();

    char *path;
    char *pathx = nil;
    char *root;
    char *fullfile;


    fullfile = (char *) getmain(strlen(file) + strlen(suffix) + 1);
    if (fullfile is nil)
      return(nil);
    strcat(strcpy(fullfile, file), suffix);

    if ((path = getenv(LINKPATH_VARNAME)) is nil) 
      if ((path = getenv(LOADPATH_VARNAME)) is nil)
	if ((path = getenv(PATH_VARNAME)) is nil) {
	  /* no path: use system default */
	  root = hrootdir();
	  pathx = path = (char *) getmain(strlen(".:") + strlen(root) +
					  strlen("/bin") + 1);
	  if (path isnt nil)
	    strcat(strcat(strcpy(path, ".:"), root), "/bin");
	}
    if (path isnt nil)
      path = pathfind(path, fullfile, R_OK);
    freemain(fullfile,strlen(fullfile)+1);
    if (pathx isnt nil)
      freemain(pathx,strlen(pathx)+1);
    return path;
}


void
io_printerror(filename, code, lineno, severity, msg)
char *filename;
int code, lineno;
char *severity;
char *msg;
{
    if (filename)
      fprintf(stderr, "\"%s\", ", filename);

    fprintf(stderr, "line %d: %s%s.\n", lineno, severity, msg);
}
