/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: decl.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)decl.ch	1.6 3/13/90";
#endif

/* this module creates and checks lists of component declarations for type
   definitions (predefined!component_declarations).  if the components have
   already been named by forward reference, the uniqueids are retrieved from
   the backpatch table with bp_defcomp() instead of being created with
   unique().

   check_declaration_list() makes sure that all components named by forward
   reference were actually defined.
*/

#include "cherm.h"
#include "storage.h"

#include "resolve.h"

#include "predefined.cd"
#include "backpatch.cd"
#include "errors.cd"

extern datarep dr_bottom;

#define isbottom(objp) ((objp)->tsdr is &dr_bottom)

objectp Declist;		/* predefined!component_declarations. */
				/* we use this to build declaration lists. */

decl *
p_decl(name, Typename, pragm)
char *name;			/* in string: name of rootid */
objectp Typename;		/* in type_name: type it is declared as */
char *pragm;			/* in string: optional pragma */
{
    decl *newdecl;

    newdecl = tnew(decl);
    newdecl->name = name;
    newdecl->typename = Typename;
    newdecl->pragm = pragm;

    return(newdecl);		/* simple, no? */
}


void
p_init_declaration_list()
{
    Declist = new_object();
    ord_avl_new_table(Declist, firstelem_key, nil);
}


objectp
p_get_declaration_list()
{
    return(Declist);
}


objectp				/* returns pointer to componentid of decl */
p_add_declaration(declp)
decl *declp;			/* in decl */
/* also uses global Currentdefinition to get the typeid of the current type */
{
    objectp bp_defcomp();

    extern objectp Backpatch;	/* backpatch record for current definition */

    objectp Declid;		/* componentid */
    hobject(SNewdecl, record);	/* component_declaration */

    if (not Backpatch or not (Declid = bp_defcomp(Backpatch, declp->name))) {
	Declid = new_object();	/* if not backpatching, or if this component */
	unique(Declid);		/*  was not in backpatch info, create compid */
    }

    new_record(SNewdecl, component_declaration);
    move(SNewdecl@Id, Declid);	/* create component id */
    move(SNewdecl@component_declaration__type, declp->typename);

    Declid = SNewdecl@Id;	/* save pointer to id */

    add_component_printname(declp->name, Currentdefinition@Id, SNewdecl@Id);

    if (insert(Declist, SNewdecl) isnt Normal) {
      hobject(Typename);
      objectp get_defmodid();

      new_record(Typename, typename);
      copy(Typename@typename__moduleid, get_defmodid());
      copy(Typename@typename__typeid, Currentdefinition@Id);
      fe_error(Fatal, errorcode__general_error,
	       "p_add_declaration",
	       "Component id for component '%s' already exists in type '%s'",
	       declp->name, pmap_type(Typename));
    }

    return(Declid);
}


void
check_declaration_list(Backpatch, Decls)
objectp Backpatch;		/* const backpatch!unres_type: backpatch */
				/*  information for the type being defined. */
objectp Decls;			/* const predefined!component_declarations: */
				/*  the component list to check. */
{
    objectp Deplist;		/* backpatch!unres_components */
    lobject(Unres);		/* backpatch!unres_component */
    lobject(Matchdecl);		/* predefined!component_declaration */

    if (Backpatch is nil)
      return;

    if (case_of(Backpatch@unres_type__dependents) is dependent_type__unknown)
	return;			/* if type unknown, then no components were */
				/*  mentioned. */

    if (case_of(Backpatch@unres_type__dependents) 
	isnt dependent_type__component) {
	fe_error(Stop_Now, errorcode__general_error,
		 "Type '%s' is used inconsistently",
		 stringval(Backpatch@unres_type__name));
	/*NOTREACHED*/
    }

    Deplist = Backpatch@unres_type__dependents@Component;
				/* variant has been checked; now reveal it. */

    initget(Unres, Deplist, nil);
    while (get_or_err(Unres, Deplist) is Normal) 
      if (h_lookup(Matchdecl, Decls, Unres@unres_component__id, 0) 
	  isnt Normal) {
	  fe_error(LASTPHASE, errorcode__general_error,
		   "Component '%s' missing from definition of type '%s'",
		   stringval(Unres@unres_component__name),
		   stringval(Backpatch@unres_type__name));
      }
}
