/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)backpatch.ch	1.6 3/13/90 */
/* edit history:
 1.2 (Tue Mar 28 14:47:21 1989 by David F. Bacon):
   added call to check_unqualname() in bp_deftype().
 */

#include "cherm.h"

#include "resolve.h"
#include "lex-yacc.h"

#include "predefined.cd"
#include "backpatch.cd"
#include "errors.cd"

hobject(SUnres_types,table); /* backpatch!unres_types */

void
bp_init()
{
    avl2_new_table(SUnres_types, firstandsecond_keyset);
				/* keys (typeid) (name) */
}

void
bp_end()
{
    hobject(SUtype, record);	/* backpatch!unres_type */

    if (size_of(SUnres_types) > 0) {
	initget(SUtype, SUnres_types, nil);

	while (get_or_err(SUtype, SUnres_types) is Normal) {
	    fe_error_at(LASTPHASE, errorcode__general_error,
			integerval(SUtype@unres_type__lineno),
			"Type '%s' was used but never defined",
			stringval(SUtype@unres_type__name));
	}

	endget(SUtype, SUnres_types);
    }
}


objectp				/* out type_name */
bp_type(name)
char *name;			/* in string */
{
    objectp get_defmodid();
    status add_type_printname();

    extern globinfo global;

    objectp Typename;		/* predefined!type_name */
    hobject(SName, charstring);
    hobject(SUnres_type, record); /* backpatch!unres_type */
    hobject(SCUnres_type, record); /* backpatch!unres_type */


    chs_lit(SName, name);

    if (h_lookup_secondary(SUnres_type, SUnres_types, SName, 0) 
	is NotFound) {

	new_record(SUnres_type, unres_type);
	unique(SUnres_type@Id);
	move(SUnres_type@unres_type__name, SName);
	unite(SUnres_type@unres_type__dependents, Bottom, 
	      dependent_type__unknown);
	ilit(SUnres_type@unres_type__lineno, global.lineno);

	if (not add_type_printname(name, SUnres_type@Id))
	  fe_error(Fatal, errorcode__general_error,
		   "bp_type",
		   "Newly backpatched type already in printmap");

	cheapcopy(SCUnres_type, SUnres_type);
	insert(SUnres_types, SCUnres_type);
    }
    else
      fe_error(Fatal, errorcode__general_error,
	       "bp_type",
	       "Typename not previously encountered, but already backpatched");

    /* now we have the entry for this type name */

    Typename = new_object();
    new_record(Typename, typename);

    copy(Typename@typename__moduleid, get_defmodid());
    copy(Typename@typename__typeid, SUnres_type@Id);

    return(Typename);
}


objectp				/* out unres_type or nil */
bp_deftype(name)
char *name;			/* constant string: type being defined */
{
    void check_unqualname();

    lobject(SName);		/* predefined!charstring */
    lobject(Findentry);		/* backpatch!unres_type */
    objectp Entry;		/* backpatch!unres_type */

    chs_lit(SName, name);

    if (h_lookup_secondary(Findentry, SUnres_types, SName, 0) 
	isnt Normal) {

	check_unqualname(name, TRUE);
				/* check if it was used as an unqualified */
				/*  name prior to being defined. */
	return(nil);
    }

    Entry = new_object();
    fremove(Entry, Findentry, SUnres_types, SECONDARY_KEY);
				/* pull it out of the bp table */
    return(Entry);
}


objectp
bplookup_type(Typeid)
objectp Typeid;			/* constant typeid */
{
    objectp CUnres_type;


    CUnres_type = new_object();
    if (h_lookup(CUnres_type, SUnres_types, Typeid, 0) 
	isnt Normal)
      fe_error(Fatal, errorcode__general_error,
	       "bplookup_type",
	       "Resolved type not in backpatch table; but it should be");

    return(CUnres_type);
}


dfd_integer
bp_enumval(name,Typename)
char *name;			/* constant string: name of enumeration val */
objectp Typename;		/* constant typename: its fake type */
{
    char *pmap_type();

    objectp CUnres_type;	/* unres_type */
    hobject(SLiteralinfo, record); /* literal_info */
    hobject(SCUnres_literal, record); /* unres_literal */
    hobject(SUnres_literal, record); /* unres_literal */
    hobject(SName, charstring);
    objectp Litinfo;		/* literal_info */
    dfd_integer id;

    CUnres_type = bplookup_type(Typename@typename__typeid);

    if (case_of(CUnres_type@unres_type__dependents) is 
	dependent_type__component) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		 "Type '%s' is used inconsistently",
		 pmap_type(Typename));
	return(0);
    }

    if (case_of(CUnres_type@unres_type__dependents) is 
	dependent_type__unknown) {
	new_record(SLiteralinfo, literal_info);
	ilit(SLiteralinfo@literal_info__nextid, 0);
	avl2_new_table(SLiteralinfo@literal_info__literals,
		      firstandsecond_keyset);
	unite(CUnres_type@unres_type__dependents, SLiteralinfo, 
	      dependent_type__named_literal);
    }

    Litinfo = CUnres_type@unres_type__dependents@Component;

    chs_lit(SName, name);

    if (h_lookup_secondary(SCUnres_literal, Litinfo@literal_info__literals,
			       SName, 0)
	is NotFound) {

	new_record(SUnres_literal, unres_literal);
	id = Litinfo@literal_info__nextid->value.integer++;
	ilit(SUnres_literal@Id, id);
	move(SUnres_literal@unres_literal__name, SName);

	insert(Litinfo@literal_info__literals, SUnres_literal);
	return(id);
    }

    return(SCUnres_literal@Id->value.integer);
				/* just return the value for this name */
}




objectp				/* out componentid */
bp_component(name,Typename)
char *name;			/* constant string: name of component */
objectp Typename;		/* constant typename: its fake type */
{
    char *pmap_type();

    hobject(SComponentinfo, table); /* unres_components */
    hobject(SComprec, nominal);	/* unres_component */
    hobject(SName, charstring);
    hobject(SUnres_component,record); /* unres_component */
    objectp CUnres_type;	/* unres_type */
    objectp CComps;		/* unres_components */
    objectp CCompid;		/* componentid */


    CUnres_type = bplookup_type(Typename@typename__typeid);

    if (case_of(CUnres_type@unres_type__dependents) is 
	dependent_type__named_literal)
      fe_error(Stop_Now, errorcode__general_error,
	       "Type '%s' is used inconsistently", pmap_type(Typename));

    if (case_of(CUnres_type@unres_type__dependents) is 
	dependent_type__unknown) {
	avl2_new_table(SComponentinfo, firstandsecond_keyset);
	unite(CUnres_type@unres_type__dependents, SComponentinfo, 
	      dependent_type__component);
    }

    CComps = CUnres_type@unres_type__dependents@Component;

    chs_lit(SName, name);
    CCompid = new_object();

    if (h_lookup_secondary(SComprec, CComps, SName, 0)
	isnt NotFound) 
      copy(CCompid, SComprec@Id);
    else {
	new_record(SUnres_component, unres_component);
	unique(SUnres_component@Id);
	move(SUnres_component@unres_component__name, SName);
	bag_new_table(SUnres_component@unres_component__occurences, 0);

	copy(CCompid, SUnres_component@Id);
	insert(CComps, SUnres_component); /* add unresolved comp for type */
    }

    return(CCompid);
}



objectp				/* out componentid */
bp_defcomp(Backpatch, name)
objectp Backpatch;		/* constant Unrestype */
char *name;
{
    objectp Comps;
    lobject(Ucomp);
    lobject(Compname);
    objectp Compid;


    if (case_of(Backpatch@unres_type__dependents) isnt 
	dependent_type__component)
      return(nil);

    Comps = Backpatch@unres_type__dependents@Component;

    chs_lit(Compname, name);
    if (h_lookup_secondary(Ucomp, Comps, Compname, 0) isnt Normal)
      return(nil);

    /* fix later: what about dependent component occurrences???!!! */

    Compid = new_object();
    copy(Compid, Ucomp@Id);

    discard(Compname);
    return(Compid);
}


objectp
bp_enumdef(Unrestype)
objectp Unrestype;
{
    lobject(SId);		/* componentid */
    lobject(SCLit);		/* unres_literal */
    objectp Litinfo;		/* literal_info */
    objectp Enumelements;	/* enumeration_values */
    int i;
    dfd_integer elemcount;


    Enumelements = new_object();
    
    switch (case_of(Unrestype@unres_type__dependents)) {
      case dependent_type__named_literal: {
	  Litinfo = Unrestype@unres_type__dependents@Component;
	  elemcount = Litinfo@literal_info__nextid->value.integer;
	  ord_avl_new_table(Enumelements, whole_key, nil);

	  for (i = 0; i < elemcount; i++) {
	      ilit(SId, i);
	      (void) h_lookup(SCLit, Litinfo@literal_info__literals, SId,
				  0);
	      insert(Enumelements, SCLit@unres_literal__name);
	  }
	  return(Enumelements);
      }

      case dependent_type__component: {
	  fe_error(Inhibit_Codegen, errorcode__general_error,
		   "Type '%s' is used inconsistently",
		   stringval(Unrestype@unres_type__name));
	  break;
      }

      case dependent_type__unknown:
	    break;
    }

    ord_avl_new_table(Enumelements, whole_key, nil);
    return(Enumelements);
}
