-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: codegen.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)codegen.pp	1.16 3/13/90

-- This is the driver process for performing code generation for an
-- absprog.  After performing various initialization chores, the main
-- process of the absprog is translated, resulting in an LI program
-- object.  The LI program is secretly stuffed into the argument
-- absprog by the 'LIStuff' function.  This function can only be
-- created via the assembler, since no real Hermes program could ever
-- access the hidden field (why?  BECAUSE IT'S HIDDEN, genius!).  Note
-- that absprog processes other than the main process (resulting from
-- the use of program literals) are recursively codegen'ed when they
-- are encountered during codegen of their parents.

#include "typemark.h"
#include "codegen.h"

codegen: using (common, interpform, codegen, cgInternal, cgInit, unix)

process (Q: codegenQ)

declare
  args: codegen;
  cgData: cgData;
  finish: signalPort;
  LIprog: interpform!prog;
  empty: empty;
begin

  -- get the absprog they want codegen'ed
  receive args from Q;

  -- consolidate some of the arguments into our grab-bag of relevant data
  new cgData;
  new cgData.Prog;
  cgData.Prog.absprog := args.absprog;
  cgData.Prog.annotations := args.annotations;
  cgData.options := args.options;
  cgData.std := args.std;

  -- Gather up the capabilities we'll be needing, as well as various
  -- tables and other constant stuff...
  block declare
    cgInit: cgInitFn;
  begin
    cgInit <- cgInitFn#(PROCESS(args.std.pathLoad(S("cginit"))));
    call cgInit(args.std.pathLoad, args.std.pathReadObj, finish, cgData);
  end block;

  -- now go codegen the main process and, recursively, all the other
  -- processes in the absprog
  LIprog <- 
      interpform!prog#(cgData.Fns.cgProcess(args.absprog.main_program,cgData));

  -- stuff LI prog into the hidden absprog field
  call cgData.Fns.LIStuff(args.absprog,LIprog);

  send empty to finish;		-- shut down servers

  return args;			-- all finished

end process
