-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: clauseusesobj.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)clauseusesobj.pp	1.5 3/13/90

-- This process determines whether or not a particular clause in a
-- Hermes program makes any mention of a given objectname.  In the
-- current implementation, embedded clauses are not examined, so a
-- 'false' result may not be correct.  Callers must therefore take
-- correct, if not optimal action on a 'false' result.

#include "typemark.h"
#include "codegen.h"

clauseUsesObj: using (cgInternal)

process (Q: clauseUsesObjQ)
  
declare
  args: clauseUsesObj;
begin
  receive args from Q;

  -- locate the clause to be examined
  inspect proc in ABSPROG.programs[args.cgData.Proc.id] begin
    inspect clause in proc.executable_part.clauses[args.clauseid] begin
      -- Now test each statement in the clause
      for stmt in clause.statements[] inspect
	for op in stmt.operands[] inspect
	  block begin
	    if B(B(op.root = args.obj.root) and
		    B(I(size of args.obj.components) <= 
		      I(size of op.components))) then
	      -- objectnames conform... make sure components of argument
	      -- object is prefix of operand's component list
	      for comp in args.obj.components[] inspect
		inspect AREF(opcomp,op.components,I(position of comp)) begin
		  if B(comp <> opcomp) then
		    exit nomatch;
		  end if;
		end inspect;
	      end for;
	      -- All components match... ready to return a true result
	      args.result <- TRUE;
	      return args;
	      exit done;
	    end if;
	  on exit(nomatch)
	    -- Break out of loop and try next operand when any
	    -- component mismatches
	  end block;
	end for;
      end for;
      -- No statement matched... return FALSE
      args.result <- FALSE;
      return args;
    end inspect;
  end inspect;
  
on exit(done)
  -- exit to here for early exit
end process
