/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)stdio.ch	1.10 3/21/90 */

#define _BSD 43

/*
 * This C-HERMES process is supposed to handle stdio
 */
/*
 ********************************************************************************** 
 *                           Includes
 ********************************************************************************** 
 */

#include <sys/types.h>
#include <sys/stat.h>

#include <fcntl.h>  /* constants for non-blocking io */
#include <stdio.h>  /* The unix-c procedures this calls */

#include "cfunc.h"  /* The interface to li */

#include "sysdep.h"

#include "predefined.cd"
#include "unix.cd"  /* The definitions it shares w/ the hermes code */
#include "interpform.cd"

/*
 ********************************************************************************** 
 *                            Defines
 ********************************************************************************** 
 */

#define MAXARGS 32  /* How much local space must allocate for the argument list */

/* needed for the RIOS */
#ifndef FNDELAY
#  define FNDELAY O_NDELAY
#endif

/*
 ********************************************************************************** 
 *                            Externals
 ********************************************************************************** 
 */

extern int errno;

/*****************************************************************************/
/*                          bogosity                                         */
/*****************************************************************************/

static objectp fread_object;

/*
 ********************************************************************************** 
 *                            Type Definitions
 ********************************************************************************** 
 */
typedef int *handle; /* A pointer to c structure or a nominal */
typedef char *string;
typedef struct
        {
        char *location;
        unsigned long size;
        } buffer;
typedef struct
        {
        char *location;
        unsigned long size,count;
        } array;

typedef union {
    /* void a_void; */          /* we'd include this if possible */
    int a_void;                 /* But this is just as well */

    status a_boolean;
    char a_char;

    short a_short;		/* signed integers */
    int a_int;
    long a_long;

    unsigned short a_u_short;	/* unsigned integers */
    unsigned int a_u_int;
    unsigned long a_u_long;
    
    handle a_handle;		/* aggregates */
    string a_string;
    buffer a_buffer;
    array  a_array;
} unixargvalue;

typedef int unixargtype; /* Will take unixoperand_type values defined in unix.cd */

typedef struct {
   unixargvalue value;
   unixargtype type;
} unixobject;

typedef unixargtype unixargtypelist[];

typedef struct {
  unixargtype ret;
  int count;
  unixargtypelist *types;
 } interface;

/*
 ********************************************************************************** 
 *                            Interface Definition Data
 ********************************************************************************** 
 */

#include "stdio_int.h"

CProc(C_stdio)
{
/*
 ********************************************************************************** 
 *                            Function definitions
 ********************************************************************************** 
 */

   status convert_hermes_to_unix();
   status convert_unix_to_hermes();
   status check_call();
   void unix_call();
 
/*
 ********************************************************************************** 
 *                            Variable definitions
 ********************************************************************************** 
 */

   objectp initportp; /* the initport is created before entry */

/* get the call msg */
    lobject(Cmsg);               
    
/* create the arglist */
    lobject(Operand);            /* temporary for processing the argument list */
    unixobject arglist[MAXARGS]; /* The arguments */
    int argcount;                /* in a counted list */

/* check it against the syscall */
    dfd_enumeration unix_function;

/* do the syscall */
    unixobject unix_return;      /* The return object */

/* return it as a hermes object */
    lobject(Hermes_return);
 
/*
 ********************************************************************************** 
 *                            Code
 ********************************************************************************** 
 */


/* get the call msg */
    initportp= &current->ep.c->initport;
    (void) copy(Cmsg, Bottom); /* We say the magic words...*/
    if (c_receive(Cmsg, initportp) isnt SUCCESS) {

    /* The first time the code is executed */

        c_wait(sched, current, initportp);
        return;
    }

/* process the arguments into an arglist */
    /* initialize transfer */
    argcount=0;
    if (initget(Operand, Cmsg@unixcall_intf__operands, nil) isnt Normal) {
	nilerror("C_stdio","couldn't get args");
	abort_nili("C_stdio");
    }
    unix_function = enumval(Cmsg@unixcall_intf__function);

    /*    this adds the representation to the list arglist[argcount] */
    while (get_or_err(Operand, Cmsg@unixcall_intf__operands) is Normal)
     if (convert_hermes_to_unix(Operand,&arglist[argcount++], unix_function)
	 is FAILURE) 
       goto exception_type_error;

/* check to make sure call is legal */
    if (check_call(unix_function,argcount,arglist) is FAILURE)
     goto exception_syntax_error;

#ifndef COMPLETE_STDIO
/* if we don't have complete stdio, raise an exception if missing functions */
/* are used. */

   switch(unix_function) {
     case syscall__ctermid:
     case syscall__cuserid:
     case syscall__tmpnam:
     case syscall__tmpfile:
       goto exception_syntax_error;
   }
#endif

/* execute call */
    unix_call(unix_function, argcount, arglist, &unix_return);
    (void)convert_unix_to_hermes(&unix_return,Hermes_return);

/* put the returned object into the callmessage */
    (void)unite(Cmsg@unixcall_intf__return,Hermes_return,unix_return.type);
    
/* return */
    c_return(sched, Cmsg);
    c_wait(sched, current, initportp);
    return;

exception_syntax_error:
    /* This should definitely be implemented as c_return_exception */
    c_discard(sched,Cmsg);
    c_wait(sched, current, initportp);
    return; 
exception_type_error:
    c_discard(sched,Cmsg);
    c_wait(sched, current, initportp);
    return; 
}

CProc(C_read_external)
{
/*
 ********************************************************************************** 
 *                            Function definitions
 ********************************************************************************** 
 */
   void read_variable();
   status convert_unix_to_hermes();
/*
 ********************************************************************************** 
 *                            Variable definitions
 ********************************************************************************** 
 */

   objectp initportp; /* the initport is created before entry */

/* get the call msg */
    lobject(Cmsg);               
    
/* do the syscall */
    unixobject unix_return;      /* The return object */

/* return it as a hermes object */
    lobject(Hermes_return);
 
/*
 ********************************************************************************** 
 *                            Code
 ********************************************************************************** 
 */


/* get the call msg */
    initportp= &current->ep.c->initport;
    (void) copy(Cmsg, Bottom); /* We say the magic words...*/
    if (c_receive(Cmsg, initportp) isnt SUCCESS) {

    /* The first time the code is executed */

        c_wait(sched, current, initportp);
        return;
    }

/* do the read */
    read_variable(enumval(Cmsg@read_external_variablecall__variable),&unix_return);
    (void)convert_unix_to_hermes(&unix_return,Hermes_return);

/* put the returned object into the callmessage */
   (void) unite(Cmsg@read_external_variablecall__result,Hermes_return,unix_return.type);
    
/* return */
    c_return(sched, Cmsg);
    c_wait(sched, current, initportp);
    return;
}

/* To be removed */ 
static handle handleval(x) 
objectp x;
{
return((handle)integerval(x)); 
} 

/*
**********************************************************************************
 * convert_hermes_to_unix

**********************************************************************************
 */ 

static status convert_hermes_to_unix(hobjectp,argp, function)
objectp hobjectp;
unixobject *argp;
dfd_enumeration function;
{
    switch (argp->type = case_of(hobjectp)) {
      case unixoperand_type__void: {
          argp->value.a_void = 0;
          return(SUCCESS);
      }
      case unixoperand_type__boolean: {
          argp->value.a_boolean = booleanval(hobjectp@Component);
          return(SUCCESS);
      }
      case unixoperand_type__char: {
	  argp->value.a_char = (char) enumval(hobjectp@Component);
          return(SUCCESS);
      }
      case unixoperand_type__short: {
	  argp->value.a_short = (short) integerval(hobjectp@Component);
          return(SUCCESS);
      }
      case unixoperand_type__int: {
	  argp->value.a_int = (int) integerval(hobjectp@Component);
          return(SUCCESS);
      }
      case unixoperand_type__long: {
	  argp->value.a_long =(long) integerval(hobjectp@Component);
          return(SUCCESS);
      }
      case unixoperand_type__unsigned_short: {
	  argp->value.a_u_short = (unsigned short) integerval(hobjectp@Component);
          return(SUCCESS);
      }
      case unixoperand_type__unsigned_int: {
	  argp->value.a_u_int = (unsigned int) integerval(hobjectp@Component);
          return(SUCCESS);
      }
      case unixoperand_type__unsigned_long: {
	  argp->value.a_u_long =(unsigned long) integerval(hobjectp@Component);
          return(SUCCESS);
      }
      case unixoperand_type__handle: {
	  argp->value.a_handle =(handle) handleval(hobjectp@Component);
          return(SUCCESS);
      }
      case unixoperand_type__string: {
	  argp->value.a_string = stringval(hobjectp@Component);
          return(SUCCESS);
      }
      case unixoperand_type__buffer: {
          /* local variables */
          char *location;
          unsigned long buffer_len;
          /* code */
          location = stringval(hobjectp@Component@buffer__string);
          buffer_len = integerval(hobjectp@Component@buffer__size);
          if (buffer_len>size_of(hobjectp@Component@buffer__string))
           return(FAILURE);
          argp->value.a_buffer.location = location;
          argp->value.a_buffer.size = buffer_len;
          return(SUCCESS);
      }
      case unixoperand_type__array: {
          /* local variables */
          char *location;
          unsigned long array_esize,array_ecount;
          /* code */
          location = stringval(hobjectp@Component@array__string);
          array_ecount = integerval(hobjectp@Component@array__count);
          array_esize = integerval(hobjectp@Component@array__size);
	  fread_object = hobjectp@Component@array__string;
/*	  if (array_ecount isnt 0 or function isnt syscall__fread)
	    if ((array_ecount*array_esize) > 
		size_of(hobjectp@Component@array__string)) 
	      return(FAILURE);
*/
          argp->value.a_array.location = location;
          argp->value.a_array.size = array_esize;
          argp->value.a_array.count = array_ecount;
          return(SUCCESS);
      }
      default: {
	  argp->value.a_void = 0;
          return(SUCCESS);
      }
    } /* switch */ 
/* done*/ 
}

/*
 **********************************************************************************
 *				 check_call
 **********************************************************************************
 */

/* Check to make sure this is a legal call */
static status check_call(sys_func, argcount, arglist) 
dfd_enumeration sys_func; 
int argcount; 
unixobject arglist[MAXARGS]; 
{
 status check_syntax(),check_specific();

 if (not check_syntax(sys_func, argcount, arglist)) return(FAILURE);
 if (not check_specific(sys_func, argcount, arglist)) return(FAILURE);
 return(SUCCESS);
}
/*
 **********************************************************************************
 *				 check_syntax
 **********************************************************************************
 */

/* Check the syntax - that the arglist matches type */
static status check_syntax(func,argc,argl)
dfd_enumeration func;
int argc;
unixobject argl[MAXARGS];
{
 int i;
 if (func>=syscall__Size)
  return(FAILURE); /* unknown function */
/* This is an escape for untyped interfaces: */
 if (syscall_intf[func].count==-1)
  return(SUCCESS); /* loose interface */
 if (argc!=syscall_intf[func].count)
  return(FAILURE); /* argument list lengths don't match */
 for (i=0;i<argc;i++)
  if ((*syscall_intf[func].types)[i]!=argl[i].type)
   return(FAILURE); /* type mismatch */
  return(SUCCESS);
}
/*
 **********************************************************************************
 *				 check_specific
 **********************************************************************************
 */
/* check the specifics - I almost resisted saying semantics */

/*ARGSUSED*/
static status check_specific(func,argc,argl)
dfd_enumeration func;
int argc;
unixobject argl[MAXARGS];
{
 switch (func) {
#ifdef COMPLETE_STDIO
 case syscall__ctermid:
  if (argl[0].value.a_buffer.size<L_ctermid)
   return(FAILURE); /* buffer to small to hold result */
  break;
 case syscall__cuserid:
  if (argl[0].value.a_buffer.size<L_cuserid)
   return(FAILURE); /* buffer to small to hold result */
  break;
 case syscall__tmpnam:
  if (argl[0].value.a_buffer.size<L_tmpnam)
   return(FAILURE); /* buffer to small to hold result */
  break;
#endif
 default:
  return(SUCCESS);
 }
 return(SUCCESS);
}

/*
**********************************************************************************
*				 unix_call
**********************************************************************************
*/ 
static void unix_call(func, argcount, arglist, retp)
dfd_enumeration func; 
int argcount; 
unixobject arglist[MAXARGS];
unixobject *retp; 
{ /* assumes checking and argument conversion already done */
    switch (func) {
      case syscall__test: {
          int i;
	  retp->value.a_void = 0;
          retp->type = unixoperand_type__void;
	  (void) fflush(stderr); /* why ya bugging? */
          (void) printf("%d arguments.\n",argcount);
          for (i=0;i<argcount;i++)
           switch(arglist[i].type) {
           case unixoperand_type__void:
            (void) printf("{void}\n");
            break;
           case unixoperand_type__boolean:
            (void) printf("{boolean:");
            if (arglist[i].value.a_boolean)
             (void) printf("false}\n");
            else
             (void) printf("true}\n");
            break;
           case unixoperand_type__char: 
            (void) printf("{char:\'%c\'}\n",arglist[i].value.a_char);
            break;           
           case unixoperand_type__short: 
            (void) printf("{short:%d}\n",arglist[i].value.a_short);
            break;
           case unixoperand_type__int: 
            (void) printf("{int:%d}\n",arglist[i].value.a_int);
            break;
           case unixoperand_type__long: 
            (void) printf("{long:%d}\n",arglist[i].value.a_long);
            break;
           case unixoperand_type__unsigned_short: 
            (void) printf("{ushort:%d}\n",arglist[i].value.a_u_short);
            break;
           case unixoperand_type__unsigned_int: 
            (void) printf("{uint:%d}\n",arglist[i].value.a_u_int);
            break;
           case unixoperand_type__unsigned_long: 
            (void) printf("{ulong:%d}\n",arglist[i].value.a_u_long);
            break;
           case unixoperand_type__handle:
            (void) printf("{handle:0x%x}\n",arglist[i].value.a_handle);
            break;           
           case unixoperand_type__string:
            (void) printf("{string:\"%s\"}\n",arglist[i].value.a_string);
            break;
           case unixoperand_type__buffer:
            (void) printf("{buffer(s=%d):%s}\n",arglist[i].value.a_buffer.size,
                                         arglist[i].value.a_buffer.location);
            break;
           case unixoperand_type__array:
            (void) printf("{array(s=%d,c=%d):%s}\n",arglist[i].value.a_array.size,
                                             arglist[i].value.a_array.count,
                                             arglist[i].value.a_array.location);
            break;
           default:
            (void) printf("Unknown?\n");
            break;
           }
      }
      case syscall__MakeNotBlock : {
          int fd;
          int old_flags;
          fd=fileno((FILE *)arglist[0].value.a_handle);
          old_flags = fcntl(fd,F_GETFL,0);
          retp->type = unixoperand_type__int;
          retp->value.a_int = fcntl(fd,F_SETFL,old_flags|FNDELAY);
          break;
      }
      case syscall__ClearErrno : {
          retp->type = unixoperand_type__void;
          retp->value.a_void = 0;
          errno = -1;
          break;
      }
      case syscall__clearerr: {
          retp->type = unixoperand_type__void;
          retp->value.a_void = 0;
          (void) clearerr((FILE *)arglist[0].value.a_handle);
          break;
      }
#ifdef COMPLETE_STDIO
      case syscall__ctermid: {
          retp->type = unixoperand_type__void;
          retp->value.a_void = 0;
          (void) ctermid(arglist[0].value.a_buffer.location);
          break;
      }
      case syscall__cuserid: {
          retp->type = unixoperand_type__void;
          retp->value.a_void = 0;
          (void) cuserid(arglist[0].value.a_buffer.location);
          break;
      }
#endif
      case syscall__fclose: {
          retp->type = unixoperand_type__void;
          retp->value.a_handle = (handle) fclose((FILE *)arglist[0].value.a_handle);
          break;
      }
      case syscall__fdopen: {
          retp->type = unixoperand_type__handle;
          retp->value.a_handle = (handle) fdopen((int)arglist[0].value.a_handle,
                                                 arglist[1].value.a_string);
          break;           
      }
      case syscall__feof: {
          retp->type = unixoperand_type__boolean;
          retp->value.a_boolean = (status) feof((FILE *)arglist[0].value.a_handle);
          break;
      }
      case syscall__ferror: {
          retp->type = unixoperand_type__boolean;
          retp->value.a_boolean = (status) ferror((FILE *)arglist[0].value.a_handle);
          break;
      }
      case syscall__fflush: {
          retp->type = unixoperand_type__void;
          retp->value.a_handle = (handle) fflush((FILE *)arglist[0].value.a_handle);
          break;
      }  
      case syscall__fgetc: {          
          retp->type = unixoperand_type__int;
          retp->value.a_int = (int) fgetc((FILE *)arglist[0].value.a_handle);
          break;
      }
      case syscall__fgets: {          
          retp->type = unixoperand_type__int;
          retp->value.a_int = (int) fgets(arglist[0].value.a_buffer.location,
                                          arglist[0].value.a_buffer.size,
                                          (FILE *)arglist[1].value.a_handle);
          break;
      }
      case syscall__fileno: {
          retp->type = unixoperand_type__handle;
          retp->value.a_handle = (handle) fileno((FILE *)arglist[0].value.a_handle);
          break;
      }
      case syscall__fopen: {
          retp->type = unixoperand_type__handle;
          retp->value.a_handle = (handle) fopen(arglist[0].value.a_string,
                                                arglist[1].value.a_string);
          break;
      }
      case syscall__fputc: {          
          retp->type = unixoperand_type__int;
          retp->value.a_int = (int) fputc(arglist[0].value.a_char,
                                          (FILE *)arglist[1].value.a_handle);
          break;
      }
      case syscall__fputs: {          
	  int fputs();		/* shouldn't be needed */

          retp->type = unixoperand_type__int;
          retp->value.a_int = (int) fputs(arglist[0].value.a_string,
                                          (FILE *)arglist[1].value.a_handle);
          break;
      }
      case syscall__fread: {
	  lobject(Ipair);
	  struct stat buf;
	  FILE *fp;
	  flag memok;
	  extern datarep dr_ord_enumeration;

          retp->type = unixoperand_type__int;

	  fp = (FILE *)arglist[1].value.a_handle;

	  if (arglist[0].value.a_array.count is 0 and
	      fstat(fileno(fp), &buf) is 0) {
	      (void) discard(fread_object);

	      memok = FALSE;

	      if (new_record(Ipair, integer_pair) isnt Normal) goto cleanup;
	      (void) ilit(Ipair@integer_pair__int_one,
			  (dfd_integer) buf.st_size);
	      (void) ilit(Ipair@integer_pair__int_two, 4096);
	      if (!chs_new_table(fread_object, Ipair)) goto cleanup;
	      memok = TRUE;

	    cleanup:
	      if (!memok) {
		  nilerror("fread","out of memory");
		  abort_nili("fread");
	      }
	      arglist[0].value.a_array.location = stringval(fread_object);
	      arglist[0].value.a_array.count =  (dfd_integer) buf.st_size;
	  }	      

          retp->value.a_int = fread(arglist[0].value.a_array.location,
                                    arglist[0].value.a_array.size,
                                    arglist[0].value.a_array.count,
                                    (FILE *)arglist[1].value.a_handle);
	  arglist[0].value.a_array.location[retp->value.a_int] = nil;
	  fread_object->value.table->size = retp->value.a_int;
	  fread_object->value.table->tsdr = &dr_ord_enumeration;
	  
          break;
      }
      case syscall__freopen: {
          retp->type = unixoperand_type__handle;
          retp->value.a_handle = (handle) freopen(arglist[0].value.a_string,
                                                  arglist[1].value.a_string,
                                                  (FILE *)arglist[2].value.a_handle);
          break;
      }
      case syscall__fseek: {          
          retp->type = unixoperand_type__int;
          retp->value.a_int = (int) fseek((FILE *)arglist[0].value.a_handle,
                                          arglist[1].value.a_long,
                                          arglist[2].value.a_int);
          break;
      }
      case syscall__ftell: {          
          retp->type = unixoperand_type__long;
          retp->value.a_long = (long) ftell((FILE *)arglist[0].value.a_handle);
          break;
      }
      case syscall__fwrite: {
          retp->type = unixoperand_type__int;
          retp->value.a_int = fwrite(arglist[0].value.a_array.location,
                                     arglist[0].value.a_array.size,
                                     arglist[0].value.a_array.count,
                                     (FILE *)arglist[1].value.a_handle);
          break;
      }
      case syscall__getc: {
          retp->value.a_int = getc((FILE *)arglist[0].value.a_handle);
          retp->type = unixoperand_type__int;
          break;
      }
      case syscall__getchar: {
          retp->value.a_int = getchar();
          retp->type = unixoperand_type__int;
          break;
      }
      case syscall__getw: {
          retp->value.a_int = getw((FILE *)arglist[0].value.a_handle);
          retp->type = unixoperand_type__int;
          break;
      }
      case syscall__pclose: {
          retp->type = unixoperand_type__void;
          retp->value.a_void = 0;
          (void) pclose((FILE *)arglist[0].value.a_handle);
          break;
      }
      case syscall__popen: {
          retp->type = unixoperand_type__handle;
          retp->value.a_handle = (handle) popen(arglist[0].value.a_string,
                                                arglist[1].value.a_string);
          break;
      }
      case syscall__putc: {
          retp->value.a_int = putc(arglist[0].value.a_char,
                                   (FILE *)arglist[1].value.a_handle);
          retp->type = unixoperand_type__int;
          break;
      }
      case syscall__putchar: {
          retp->value.a_int = putchar(arglist[0].value.a_char);
          retp->type = unixoperand_type__int;
          break;
      }
      case syscall__puts: {
	  int puts();		/* shouldn't be needed */

          retp->value.a_int = puts(arglist[0].value.a_string);
          retp->type = unixoperand_type__int;
          break;
      }
      case syscall__putw: {
          retp->value.a_int = putc(arglist[0].value.a_int,
                                   (FILE *)arglist[1].value.a_handle);
          retp->type = unixoperand_type__int;
          break;
      }
      case syscall__rewind: {          
          retp->type = unixoperand_type__void;
          retp->value.a_void = 0;
          (void) rewind((FILE *)arglist[0].value.a_handle);
          break;
      }
#ifndef sgi
      case syscall__setlinebuf: {          
          retp->type = unixoperand_type__void;
          retp->value.a_void = 0;
          (void) setlinebuf((FILE *)arglist[0].value.a_handle);
          break;
      }
#endif
#ifdef COMPLETE_STDIO
      case syscall__tmpfile: {
          retp->type = unixoperand_type__handle;
          retp->value.a_handle = (handle) tmpfile();
          break;
      }
      case syscall__tmpnam: {
          retp->type = unixoperand_type__int;
          retp->value.a_int = (int) tmpnam(arglist[0].value.a_buffer.location);
          break;
      }
#endif
      default: {
	  retp->value.a_void = 0;
          retp->type = unixoperand_type__void;
	  break;
	}
  }
}

/*
 ********************************************************************************** 
 *                            convert_unix_to_hermes
 ********************************************************************************** 
 */
static status convert_unix_to_hermes(uobjp,hobjp)
objectp hobjp; /* pointer to already allocated space */
unixobject *uobjp;
{
 switch (uobjp->type) {
      case unixoperand_type__void: {
          (void) copy(hobjp, Bottom); /* I don't know.. */
          return(SUCCESS);
      }
      case unixoperand_type__boolean: {
          (void) h_boolean(hobjp, uobjp->value.a_boolean);
          return(SUCCESS);
      }
      case unixoperand_type__char:
	(void)enum_lit(hobjp, (unsigned char) uobjp->value.a_char);
       return(SUCCESS);
      case unixoperand_type__short: 
      case unixoperand_type__int: 
      case unixoperand_type__long: 
      case unixoperand_type__unsigned_short: 
      case unixoperand_type__unsigned_int: 
      case unixoperand_type__unsigned_long: {
          (void) ilit(hobjp,uobjp->value.a_u_long);
          return(SUCCESS);
      }
      case unixoperand_type__handle: {
          (void) ilit(hobjp,uobjp->value.a_u_long);
          return(SUCCESS);
      }
      case unixoperand_type__string: {
          if (!chs_lit(hobjp, uobjp->value.a_string)) {
	      nilerror("stdio","out of memory");
	      abort_nili("stdio");
	  }
          return(SUCCESS);
      }
      case unixoperand_type__buffer: {
          /* temporary */
/*          unsigned long size; */
          /* code */
/*          size = uobjp->value.a_buffer.size; */

	  if (new_record(hobjp,buffer) isnt Normal) goto cleanup1;
	  (void) ilit(hobjp@buffer__size,uobjp->value.a_buffer.size);
	  (void) copy(hobjp@buffer__string, Bottom);
/*
          if (new_table(hobjp@buffer__string,uobjp->value.a_buffer.size,
	      256) isnt Normal) goto cleanup1;
*/
	  return(SUCCESS);

	cleanup1:
	  nilerror("stdio","out of memory");
	  abort_nili("stdio");
      }
      case unixoperand_type__array: {
          /* temporary */
/*          unsigned long size; */
          /* code */
/*          size = (uobjp->value.a_array.size)*(uobjp->value.a_array.count); */

	  if (new_record(hobjp,array) isnt Normal) goto cleanup2;
	  (void) ilit(hobjp@array__size,uobjp->value.a_array.size);
	  (void) ilit(hobjp@array__count,uobjp->value.a_array.count);
	  (void) copy(hobjp@array__string, Bottom);
/*
          if (new_table(hobjp@buffer_string,size,256) isnt Normal) 
	    goto cleanup2;
*/
	  return(SUCCESS);

	cleanup2:
	  nilerror("stdio","out of memory");
	  abort_nili("stdio");
      }
      default: {
          (void) ilit(hobjp,uobjp->value.a_long);
          return(SUCCESS);
      }
 }
}

static void
read_variable(variable,result)
dfd_enumeration variable;
unixobject *result;
{
switch (variable) {
 case external_variable__errno:
  result->type = unixoperand_type__int;
  result->value.a_int = (int) errno;
  break;
 case external_variable__stdout:
  result->type = unixoperand_type__handle;
  result->value.a_handle = (handle) stdout;
  break;
 case external_variable__stdin:
  result->type = unixoperand_type__handle;
  result->value.a_handle = (handle) stdin;
  break;
 case external_variable__stderr:
  result->type = unixoperand_type__handle;
  result->value.a_handle = (handle) stderr;
  break;
 default:
  result->type = unixoperand_type__void;
  result->value.a_void = (int) 0;
  break;
 }
}
