/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: defacts.ch */
/* Author: David Bacon & Andy Lowry */
/* SCCS Info: @(#)defacts.ch	1.4 3/13/90 */

#include <string.h>
#include <sys/file.h>

#include "cherm.h"

#include "predefined.cd"
#include "filedef.cd"


hobject(Modules, table);	/* predefined!definitions_printmappings */

void
defmod_init()
{
    avl2_new_table(Modules, firstandsecond_keyset);
}


void
defmod_import(modname)
char *modname;
{
    char *hermpath();

    hobject(Filedef, record);	/* the filed definition module */
    hobject(Name, charstring);
    char *filename;


    filename = hermpath(modname, ".do");
    chs_lit(Name, filename);
    read(Filedef, Name);	/* read in from the file */

    insert(Modules, Filedef@filed_definition__defmap);
				/* save the definitions printmap */

/*    discard(Filedef); */
/* fix later: chs_lit with empty string "" seems to produce nil pointer.  see */
/* fe/p_definitions.ch:add_type_def */

}


static char *
hermpath(file, suffix)
char *file;
char *suffix;
{
    char *pathfind();
    char *getenv();
    char *hbindir();

    char *path;
    char *fullfile, *bin;


    fullfile = (char *) malloc(strlen(file) + strlen(suffix) + 1);
    strcpy(fullfile, file);
    strcat(fullfile, suffix);

    if ((path = getenv("HPATH")) is nil) {
      bin = hbindir();
      path = (char *) malloc(strlen(".:")+strlen(bin)+1);
      strcat(strcpy(path, ".:"), bin);
    }
    return(pathfind(path, fullfile, R_OK));
}

objectp
defmod_resolve_typename(module, type)
char *module;
char *type;
{
    hobject(Modulestr, charstring);
    hobject(Typestr, charstring);
    hobject(Printrec, record);
    hobject(Typerec, record);
    objectp Typename;
    char err[256];


    Typename = new_object();
    new_record(Typename, typename);
    chs_lit(Modulestr, module);
    chs_lit(Typestr, type);

    if (h_lookup_secondary(Printrec, Modules, Modulestr, 0) is NotFound) {
	strcpy(err, module);
	yyerror(strcat(err, " is not a known module"));
	return(Typename);
    }

    copy(Typename@typename__moduleid, Printrec@Id);

    if (h_lookup_secondary(Typerec, Printrec@definitions_printmap__types,
			       Typestr, 0) is NotFound) {
	strcpy(err, type);
	yyerror(strcat(err, " is not a known type"));
	return(Typename);
    }

    copy(Typename@typename__typeid, Typerec@Id);
       
    return(Typename);
}


objectp
defmod_resolve_userex(Typename, name)
objectp Typename;		/* predefined!typename: callmsg type */
char *name;			/* string: name of exception */
{
    hobject(Prec, record);	/* definitions_printmap */
    hobject(Erec, record);	/* exception_printrec */
    hobject(Ename, chs_table);	/* charstring */
    objectp Userex;		/* user_exception */
    char err[128];

    if (h_lookup(Prec, Modules, Typename@typename__moduleid, 0) 
	is NotFound) {
	yyerror("Panic: can't find resolved module id");
	return(nil);
    }

    Userex = new_object();
    new_record(Userex, user_exception);
    chs_lit(Ename, name);

    if (h_lookup_secondary(Erec, Prec@definitions_printmap__exceptions,
			       Typename@typename__typeid, Ename, 0)
	is NotFound) {
	yyerror(strcat(strcpy(err, name), " isn't a defined exception"));
	unique(Userex@user_exception__exceptionid);
				/* make up a bogus id */
    }
    else
      copy(Userex@user_exception__exceptionid, 
	   Erec@exception_printrec__exception);

    move(Userex@user_exception__type, Typename);
    return(Userex);
}
