/* Test class Date

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: uunet!ncifcrf.gov!nih-csl!keith
	Internet: keith%nih-csl@ncifcrf.gov

Function:
	
Modification History:
	
$Log:	date.c,v $
 * Revision 2.2  88/11/22  11:08:13  keith
 * Change return from main() to exit(1).
 * 
 * Revision 2.1  88/11/21  17:33:36  keith
 * Update for rewritten version of class Date.
 * 
 * Revision 2.1  88/10/24  08:25:00  ted
 * Added more function calls after the printing of datelist.
 *
 * Revision 2.0  88/03/29  13:26:10  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  22:24:32  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: date.c,v 2.2 88/11/22 11:08:13 keith Exp $";

#include "Date.h"
#include "SortedCltn.h"

main()
{
	cout << "\nTest class Date\n";
	char junk[100];
	Date today;
	Date tomorrow(today+1);
	Date yesterday(today-1);
	Date reference(25,"Dec",1985);
	Date ref_copy = reference;
	SortedCltn datelist;
	dayTy   d;
	
//      This portion is to check those functions of Date which only need
//      to be tested once.
	
	cerr << "Today is " << nameOfDay(today.weekDay()) << ", " << today << "\n";
	cerr << "Tomorrow is " << nameOfDay(tomorrow.weekDay()) << ", " << tomorrow << "\n";
	cerr << "Yesterday was " << nameOfDay(yesterday.weekDay()) << ", " << yesterday << "\n";

	cout << "Date(5) = "  << Date(5) << "\n";
	cout << "Date(-3) = " << Date(-3) << "\n";
	cout << "Date(367, 1984) = " << Date(367,1984) << "\n";
	cout << "Date(-1, 1984) = " << Date(-1,1984) << "\n";
	cout << "nameOfMonth(6) = " << nameOfMonth(6) << "\n";

	cout << "Enter string for dayOfWeek: ";
 	cin  >> junk;
	if (cin.eof()) { cout << "\n"; exit(1); }	
	cout << form("dayOfWeek(%s) = %hd\n", junk, dayOfWeek(junk));
	cout << "Enter string for numberOfMonth: ";
	cin  >> junk;
	if (cin.eof()) { cout << "\n"; exit(1); }	
	cout << form("numberOfMonth(%s) = %hd\n", junk, numberOfMonth(junk));
	cout << "Enter number for nameOfDay: ";
	cin  >> d;
	if (cin.eof()) { cout << "\n"; exit(1); }	
	cout << form("nameOfDay(%hd) = %s\n", d, nameOfDay(d));

	cout << "Reference date is " << ref_copy << "\n";
	cout << "Enter date for scanFrom: ";
	ref_copy.scanFrom(cin);
	cout << "Replaced ref_copy by " << ref_copy << "\n";

//	Now do the repetitive stuff.

	while (YES) {
		cout << "Enter date: "; Date& date = *new Date(cin); cout << "\n";
		if (cin.eof()) break;
		if (cin.fail()) { cout << "Bad date\n";  cin.clear();  cin.get(junk,sizeof junk);  continue; }
		cout << nameOfDay(date.weekDay()) << ", " << date << "\n";
		cout << reference << " - " << date << " = " << (reference-date) << "\n";
		cout << date << " between(1-Jan-85, 31-Dec-85): " << (date.between(Date(1,"Jan",85), Date(31,"Dec",85))) << "\n";
		cout << date << " max(" << reference << ") = " << date.max(reference) << "\n";
		cout << date << " min(" << reference << ") = " << date.min(reference) << "\n";
		cout << "The date of the previous Sunday is " << date.previous("Sun") << "\n";
		cout << "The date of the previous Thursday is " << date.previous("Thursday") << "\n";
		cout << "date.compare(reference) = " << date.compare(reference) << "\n";
		cout << "date.day() = "     << date.day()          << "\n";
		cout << "date.dayOfMonth() = "       << date.dayOfMonth()       << "\n";
		cout << "daysInYear(date.year()) = " << daysInYear(date.year()) << "\n";
		cout << "date.firstDayOfMonth() = "  << date.firstDayOfMonth()  << "\n";
		cout << "date.hash() = "	     << date.hash()		<< "\n";
		cout << "date.isEqual(reference) = " << date.isEqual(reference)	<< "\n";
		cout << "this + 50 = " 		     << date + 50		<< "\n";
		cout << "50 + this = "		     << 50 + date		<< "\n";
		cout << "this - 60  = "		     << date - 60		<< "\n";
		cout << "this < reference = "	     << (date < reference)	<< "\n";
		cout << "this > reference = "	     << (date > reference)	<< "\n";
		cout << "this <= reference = "	     << (date <= reference)	<< "\n";
		cout << "this >= reference = "	     << (date >= reference)	<< "\n";
		cout << "this == reference = "	     << (date == reference)	<< "\n";
		cout << "this != reference = "	     << (date != reference)	<< "\n";
		Date date1=date;
		date1 += 50;
		cout << "this += 50 = "		     << date1			<< "\n";
		Date date2=date;
		date2 -= 60;
		cout << "this -=60 = "		     << date2			<< "\n";
		datelist.add(date);
		cout << datelist << "\n";

	} // while(YES)
	cout << "\n";	
}
