/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  polygon.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef POLYGONH
#define POLYGONH

#include <LEDA/point.h>
#include <LEDA/segment.h>
#include <LEDA/line.h>

//------------------------------------------------------------------------------
// polygons
//------------------------------------------------------------------------------


class list(polygon);


struct polygon_rep {

  list(segment) seg_list;
  int   count;
   
  polygon_rep(list(segment) L);
  polygon_rep();

  LEDA_MEMORY(polygon_rep)
   
};



class polygon   : public LEDA_SIMPLE 
{

/* polygon_rep* ptr(); */

polygon_rep* ptr() const { return (polygon_rep*)PTR; }

bool check();

public:

polygon();
polygon(list(point)&, bool=true);
polygon(const polygon& P);
void clear();

~polygon()                { clear(); }


list(point)   vertices() const;  
list(segment) segments() const { return ptr()->seg_list; }

bool          inside  (point p); 
bool          outside (point p); 

list(point)   intersection(segment s);
list(point)   intersection(line l);  
list(polygon) intersection(polygon P);

polygon       translate(double, double);
polygon       translate(const vector&);

polygon       rotate(point, double);
polygon       rotate(double);

int         size()                  { return ptr()->seg_list.size(); }
bool        empty()                 { return ptr()->seg_list.empty(); }

polygon& operator=(const polygon& P) { PTR = P.ptr(); ptr()->count++; return *this; }

polygon operator+(const vector& v) { return translate(v); }

friend ostream& operator<<(ostream& out, const polygon& p);
friend istream& operator>>(istream& in,  polygon& p);

friend void Print(const polygon& P, ostream& out = cout){ out << P; } 
friend void Read(polygon& P, istream& in = cin) { in  >> P; }

friend void Clear(polygon& P)         { P.clear(); }
friend GenPtr Copy(polygon& P)  { P.ptr()->count++; return P.PTR; }
friend polygon& Access(const polygon&, const GenPtr& p){ return *(polygon*)&p; }

};

declare(list,polygon)


//------------------------------------------------------------------------------
// POLYGON(cmp): polygons with user defined linear order cmp
//------------------------------------------------------------------------------

#define POLYGON(cmp) name2(polygon_,cmp)

#define POLYGONdeclare(cmp)\
struct POLYGON(cmp) : public polygon \
{  POLYGON(cmp)(polygon  p )         : polygon(p)   {}\
   POLYGON(cmp)(POLYGON(cmp)& p)     : polygon(p)   {}\
   POLYGON(cmp)() {}\
 ~ POLYGON(cmp)() {}\
};\
\
int compare(POLYGON(cmp)& x, POLYGON(cmp)& y) { return cmp(x,y); }




#endif 
