/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  d2_dictionary.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


/*******************************************************************************
+
+  LEDA  2.1.5                                                 02-27-1992
+
+
+  d2_dictionary.h
+
+
+  Copyright (c) 1991  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef D2_DICTIONARY_H
#define D2_DICTIONARY_H

#include <LEDA/range_tree.h>


typedef range_tree_item dic2_item;

typedef list(range_tree_item) list(dic2_item);


//--------------------------------------------------------------------
// 2-dim Dictionary
//--------------------------------------------------------------------

#define d2_dictionary(type1,type2,itype) name4(type1,type2,itype,d2_dictionary)
#define d2_dict(type1,type2,itype) name4(type1,type2,itype,d2_dict)


#define d2_dictionarydeclare3(type1,type2,itype)\
\
struct d2_dict(type1,type2,itype) : public range_tree {\
\
type1 name2(type1,X1);\
type2 name2(type2,X2);\
itype name2(itype,X3);\
\
void clear_key(GenPtr& x) const  { Clear(ACCESS1(type1,(*(tuplep&)x)[0]));\
                                   Clear(ACCESS2(type2,(*(tuplep&)x)[1])); }\
\
void clear_inf(GenPtr& x) const  { Clear(ACCESS3(itype,(*(tuplep&)x).info()));}\
\
void copy_key(GenPtr& x)  const  { Copy(ACCESS1(type1,(*(tuplep)x)[0]));\
                                   Copy(ACCESS2(type2,(*(tuplep)x)[1])); }\
\
void copy_inf(GenPtr& x)  const  { Copy(ACCESS3(itype,(*(tuplep)x).info()));}\
\
int cmp_tuple_entry(int i,tuplep p, tuplep q) const \
{ if (i==1) return compare(ACCESS1(type1,(*p)[0]),ACCESS1(type1,(*q)[0]));\
  else      return compare(ACCESS2(type2,(*p)[1]),ACCESS2(type2,(*q)[1]));\
 }\
\
range_tree* new_range_tree(int dim)\
{ return new d2_dict(type1,type2,itype)(dim); }\
\
type1 key1(dic2_item x)   { return ACCESS1(type1,(*x)[0]);  }\
type2 key2(dic2_item x)   { return ACCESS2(type2,(*x)[1]);  }\
\
itype inf(dic2_item x)    { return ACCESS3(itype,x->info());}\
\
void  change_inf(dic2_item x, itype i) { Clear(ACCESS3(itype,x->info()));\
                                         x->info() = Copy(i); }\
\
dic2_item min_key1()       { return range_tree::min(1); }\
dic2_item max_key1()       { return range_tree::max(1); }\
dic2_item min_key2()       { return range_tree::min(2); }\
dic2_item max_key2()       { return range_tree::max(2); }\
\
\
dic2_item insert(type1 x,type2 y,itype i)\
{ tuplep p = new tuple(Copy(x),Copy(y));\
  p->info() = Copy(i);\
  return range_tree::insert_tuple(p);\
 }\
\
void del(type1 x,type2 y)\
{ tuple p(Convert(x),Convert(y));\
  range_tree::del(&p);\
 }\
\
void del_item(dic2_item it)\
{ range_tree::del(it);\
 }\
\
list(dic2_item) all_items()\
{ return all_tuples();\
 }\
\
list(dic2_item) range_search(type1 x0,type1 x1,type2 y0,type2 y1)\
{ list(dic2_item) L;\
  tuple p(Convert(x0),Convert(y0));\
  tuple q(Convert(x1),Convert(y1));\
  range_tree::query_tuples(&p,&q,L);\
  return L;\
 }\
\
dic2_item lookup(type1 x,type2 y)\
{ tuple q(Convert(x),Convert(y));\
  q.set_cmp(1);\
  bb_tree_item p=rm_tree::lookup(&q);\
  dic2_item r = ( p ? key(p) : 0);\
  return r;\
 }\
\
d2_dict(type1,type2,itype)(int dim = 2) : range_tree(dim) { }\
\
~d2_dict(type1,type2,itype)() { clear(); }\
\
} ;\
\
struct d2_dictionary(type1,type2,itype) : public d2_dict(type1,type2,itype) {\
\
list(dic2_item) L;\
\
void init_iteration()\
{ L = all_tuples();\
 }\
\
d2_dictionary(type1,type2,itype)()  {}\
~d2_dictionary(type1,type2,itype)() {}\
\
}; 

// --------------------------------------------------------------------
// iteration
// --------------------------------------------------------------------

#define forall_dic2_items(x,T)  (T).init_iteration(); forall(x,(T).L )


#endif
