/*


 Copyright (C) 1990 Texas Instruments Incorporated.

 Permission is granted to any individual or institution to use, copy, modify,
 and distribute this software, provided that this complete copyright and
 permission notice is maintained, intact, in all copies and supporting
 documentation.

 Texas Instruments Incorporated provides this software "as is" without
 express or implied warranty.


 *
 * Edit history
 * Created: LGO 30-Mar-89 -- Initial design and implementation.
 *
 * Simple macro to compress out whitespace
 */

#include "defmacio.h"

int compress (argc, argv)
     int argc;
     char* argv[];
{
  char c;
  char* body;
  char* bp;
  scan_next(' ');			  /* Skip macro name */
  c = skip_blanks();
  if (c != '{') {
    fprintf(stderr, "COMPRESS: Body missing");
    return 1;
  }
  unget();
  body = savestring(scan_next('}'));		  /* Grab the macro body */
  while(*body++ != '{');		  /* strip start of body */
  bp = body + strlen(body);		  /* Strip end of body */
  while(bp > body && *bp != '}') bp--;
  while(bp > body && isspace(*(bp-1))) bp--;
  *bp = EOS;

  for (;;) {
    while (isspace(c = *body)) body++;
    while (!isspace(c = *body++)) {
      if (c == EOS) return 0;
      putchar(c);
    }
    putchar(' ');
  }
}
