//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/String.h>		// COOL String class
#include <cool/Date_Time.h>		// COOL DateTime class
#include <cool/List.h>			// COOL List class

DECLARE List<Generic*>;			// Define list of Generic*
IMPLEMENT List<Generic*>;		// Implement list of Generic*

class my_class : public Generic {
private:
  int i;
public:
  my_class (int value) {
    this->i = value;
  }
  ~my_class ();
  const int& get() const {
    return this->i;
  }
  friend ostream& operator<< (ostream& os, const my_class* m) {
    os << m->get();
    return os;
  }
  friend ostream& operator<< (ostream& os, const my_class& m) {
    os << m.get();
    return os;
  }
};

my_class::~my_class () {}

void process_list (List<Generic*>& g) {
  for (g.reset(); g.next(); ) {
    cout << "Item is a `" << ((g.value())->type_of())->name() << "' ";
    cout << "and its value is: " << g.value() << "\n";
  }
}


int main () {
  String s1("This is a string object"); // Initialize String object
  set_default_country(SWEDEN);		// Set Sweden country code
  set_default_time_zone(WET);		// Western Europe time zone
  Date_Time d1;				// Declare DateTime object
  d1.parse("5:44pm 86-10-15");		// Parse a date/time string
  my_class m1(3);			// Initialize my_class object
  List<Generic*> lg (3, &s1, &d1, &m1);	// List with 3 generic objects
  process_list (lg);			// Iterate through list
  return 0;				// Exit with valid return code
}
