//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 07/18/89 -- Initial design and implementation
//
// The Binary_Node class implements  nodes for binary trees  that have  no data
// slot.  This node class contains left and right subtree pointers.   Since the
// Binary_Node   class is  intended   for the  sole   use of  the parameterized
// Binary_Node<Type> class, all constructors and  methods are protected and the
// Binary_Tree class is declared as a friend class.
//
// The private data section contains two  pointers to Binary_Node  objects, one
// for the left subtree and one for the right subtree.  There are two protected
// constructors  for the class.   The first takes  no arguments and initializes
// the two pointers to  NULL.     The  second takes   a  reference  to  another
// Binary_Node object and duplicates its values.
//
// Methods are provided to determine if a node  is a  leaf or  the root of some
// subtree and implement member-wise assignment from one Binary_Node to another
// via the overloaded operator=.
//

#ifndef BASE_BINARY_NODEH			// If no definition for class
#include <cool/Base_BN.h>				// Include header file
#endif	

// Binary_Node -- Simple constructor to initialize a node object
// Input:         None
// Output:        None

Binary_Node::Binary_Node () {
  this->ltree = NULL;				// Initialize left subtree
  this->rtree = NULL;				// Initialize right subtree
  this->avl_balance = 0;			// Initialize avl balance
}


// Binary_Node -- Constructor to assign values to the subtree pointers 
// Input:         Reference to Binary_Node object
// Output:        None

Binary_Node::Binary_Node (const Binary_Node& bn) {
  this->ltree = bn.ltree;			// Assign left subtree
  this->rtree = bn.rtree;			// Assign right subtree
  this->avl_balance = bn.avl_balance;		// Assign avl balance
}


// ~Binary_Node -- Destructor for the Binary_Node class
// Input:          None
// Output:         None

Binary_Node::~Binary_Node () {
  delete this->ltree;				// Delete left subtree
  delete this->rtree;				// Delete right subtree
}


// operator= -- Overload assignment for Binary_Node to assign values
//              to the subtree pointers
// Input:       Reference to Binary_Node object
// Output:      Reference to Binary_Node object

Binary_Node& Binary_Node::operator= (const Binary_Node& bn) {
  this->ltree = bn.ltree;			// Assign left subtree
  this->rtree = bn.rtree;			// Assign right subtree
  this->avl_balance = bn.avl_balance;		// Assign avl balance
  return *this;					// Return updated object
}
