//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 05/22/89 -- Initial design and implementation
// Updated: MBN 09/16/89 -- Added conditional exception handling
// Updated: LGO 11/24/89 -- Remove inline
// Updated: MJF 03/12/90 -- Added group names to RAISE
//

#include <cool/Generic.h>
#include <cool/Properties.h>

// remove -- Remove property/value pair from Symbol property list
// Input:    Property lookup value
// Output:   Boolean TRUE/FALSE

Boolean Symbol::remove(const Symbol* property) {
#if ERROR_CHECKING
  if (this->proplist == NULL)			// If no property list
    RAISE (Error, SYM(Symbol), SYM(No_Plist),
	   "Symbol::remove(): No property list for symbol %s",
	   this->pname);
#endif
  return proplist->remove(property);		// Return TRUE/FALSE of remove
}
