//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 04/04/89 -- Initial design and implementation
// Updated: LGO 01/02/90 -- Make c_trim, c_left_trim, c_right_trim modify
//                          in-place, instead of copy.
// Updated: LGO 01/05/90 -- Split into seperate files
//

#include <cool/char.h>		// Include char* specification header file

// c_trim -- Removes any occurrence of the character(s) in "rem" from "str"
// Input:    Source string and token string
// Output:   Source string (string is modified in place)

char* c_trim (char* str, const char* rem) {	// Trim characters from string
  char* s = str;
  char* result = str;
  register char c;
  while ((c=*s++) != END_OF_STRING) {
    register const char* r = rem;
    register char t;
    while ((t=*r++) != END_OF_STRING && t != c); // Scan for match
    if (t == END_OF_STRING)			 // If no match found
      *result++ = c;
  }
  *result = END_OF_STRING;			// NULL terminate string
  return str;					// Return pointer to string
}
