//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 04/04/89 -- Initial design and implementation
// Updated: LGO 01/05/90 -- Split into seperate files
//

#include <cool/char.h>		// Include char* specification header file

Boolean is_equal_n (const char* c1, const char* c2, int n, Boolean case_flag) {
  if (case_flag == SENSITIVE) {			// Case sensitive
    for ( ; --n >= 0 && *c1 == *c2; c1++, c2++)	// For each character in string
      if (*c1 == END_OF_STRING)			// If end of first string
	return TRUE;				// Match found, return TRUE
    return n<0; 		                // Return match result
  }
  else {					// Case insensitive
    for ( ; --n >= 0 && *c1 == *c2 || TO_UPPER (*c1) == TO_UPPER (*c2);
	c1++, c2++)
      if (*c1 == END_OF_STRING)			// If end of first string
	return TRUE;				// Match found, return TRUE
    return n<0; 		                // Return match result
  }
}
