//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/Matrix.h>
#include <test.h>

DECLARE Matrix<int>;
IMPLEMENT Matrix<int>;
DECLARE Matrix<double>;
IMPLEMENT Matrix<double>;

void test_int () {
  int result = 0;
  Matrix<int> m0(2,2);
  TEST ("Matrix<int> m0(2,2)", (m0.rows()==2 && m0.columns()==2), 1);
  Matrix<int> m1(3,4);
  TEST ("Matrix<int> m1(3,4)", (m1.rows()==3 && m1.columns()==4), 1);
  Matrix<int> m2(2,2,2);
  TEST ("Matrix<int> m2(2,2,2)",(m2.get(0,0)==2 && m2.get(0,1)==2 && m2.get(1,0)==2 && m2.get(1,1)==2),1);
  TEST ("m0=2", (m0=2,(m0.get(0,0)==2 && m0.get(0,1)==2 && m0.get(1,0)==2 && m0.get(1,1)==2)),1);
  TEST ("m0 == m2", (m0 == m2), TRUE);
  TEST ("(m0 == m2)", (m0 == m2), TRUE);
  TEST ("m2.put(1,1,3)", (m2.put(1,1,3),m2.get(1,1)), 3);
  TEST ("m2.get(1,1)", m2.get(1,1), 3);
  TEST ("m0 == m2", (m0 == m2), FALSE);
  TEST ("m0 != m2", (m0 != m2), TRUE);
  TEST ("(m0 == m2)", (m0 == m2), FALSE);
  TEST ("m1.fill(3)",(m1.fill(3),(m1.get(0,0)==3 && m1.get(1,1)==3 && m1.get(2,2)==3 && m1.get(2,3)==3)),1);
  TEST ("m2.fill(2)",(m2.fill(2),(m2.get(0,0)==2 && m2.get(0,1)==2 && m2.get(1,0)==2 && m2.get(1,1)==2)),1);
  Matrix<int> m3(1,3,3,1,2,3);
  TEST ("m3(1,3,3,1,2,3)",(m3.get(0,0)==1 && m3.get(0,1)==2 && m3.get(0,2)==3), 1);
  Matrix<int> m4(m3);
  TEST ("Matrix<int> m4(m3)", (m3==m4), TRUE);
  TEST ("m0=m2", (m0=m2, (m0==m2)), TRUE);
  TEST ("m0=m2+3",((m0=m2+3),(m0.get(0,0)==5 && m0.get(0,1)==5 && m0.get(1,0)==5 && m0.get(1,1)==5)),1);
  TEST ("m0+=(-3)",(m0+=(-3),(m0.get(0,0)==2 && m0.get(0,1)==2 && m0.get(1,0)==2 && m0.get(1,1)==2)),1);
  Matrix<int> m5(2,2);
  TEST ("m5=m0+m2",((m5=m0+m2),(m5.get(0,0)==4 && m5.get(0,1)==4 && m5.get(1,0)==4 && m5.get(1,1)==4)),1);
  TEST ("m0+=m2", ((m0+=m2),(m0.get(0,0)==4 && m0.get(0,1)==4 && m0.get(1,0)==4 && m0.get(1,1)==4)),1);
  TEST ("m4=m3*5",((m4=m3*5),(m4.get(0,0)==5 && m4.get(0,1)==10 && m4.get(0,2)==15)),1);
  TEST ("m3*=5",((m3*=5), (m3== m4)), TRUE);
  Matrix<int> m6(2,2,4,1,2,3,4);
  TEST ("Matrix<int> m6(2,2,4,1,2,3,4)", m6.get(1,1), 4);
  Matrix<int> m7(2,2,4,5,6,7,8);
  TEST ("Matrix<int> m7(2,2,4,5,6,7,8)", m7.get(1,1), 8);
  TEST ("m5=m6*m7", ((m5=m6*m7),(m5.get(0,0)==19 && m5.get(0,1)==22 && m5.get(1,0)==43 && m5.get(1,1)==50)),1);
  TEST ("m6*=m7", ((m6*=m7),(m6.get(0,0)==19 && m6.get(0,1)==22 && m6.get(1,0)==43 && m6.get(1,1)==50)),1);
}

void test_double () {
  double result = 0.0;
  Matrix<double> d0(2,2);
  TEST ("Matrix<double> d0(2,2)", (d0.rows()==2 && d0.columns()==2), 1);
  Matrix<double> d1(3,4);
  TEST ("Matrix<double> d1(3,4)", (d1.rows()==3 && d1.columns()==4), 1);
  Matrix<double> d2(2,2,2.0);
  TEST ("Matrix<double> d2(2,2,2.0)",(d2.get(0,0)==2.0 && d2.get(0,1)==2.0 && d2.get(1,0)==2.0 && d2.get(1,1)==2.0),1);
  TEST ("d0=2.0", (d0=2.0,(d0.get(0,0)==2.0 && d0.get(0,1)==2.0 && d0.get(1,0)==2.0 && d0.get(1,1)==2.0)),1);
  TEST ("d0 == d2", (d0 == d2), TRUE);
  TEST ("(d0 == d2)", (d0==d2), TRUE);
  TEST ("d2.put(1,1,3.0)", (d2.put(1,1,3.0),d2.get(1,1)), 3.0);
  TEST ("d2.get(1,1)", d2.get(1,1), 3.0);
  TEST ("d0 == d2", (d0 == d2), FALSE);
  TEST ("d0 != d2", (d0 != d2), TRUE);
  TEST ("(d0 == d2)", (d0==d2), FALSE);
  TEST ("d1.fill(3.0)",(d1.fill(3.0),(d1.get(0,0)==3.0 && d1.get(1,1)==3.0 && d1.get(2,2)==3.0 && d1.get(2,3)==3.0)),1);
  TEST ("d2.fill(3.0)",(d2.fill(2.0),(d2.get(0,0)==2.0 && d2.get(0,1)==2.0 && d2.get(1,0)==2.0 && d2.get(1,1)==2.0)),1);
  Matrix<double> d3(1,3,3,1.0,2.0,3.0);
  TEST ("d3(1,3,3,1.0,2.0,3.0)",(d3.get(0,0)==1.0 && d3.get(0,1)==2.0 && d3.get(0,2)==3.0), 1);
  Matrix<double> d4(d3);
  TEST ("Matrix<double> d4(d3)", (d3 == d4), TRUE);
  TEST ("d0=d2", (d0=d2,  (d0==d2)), TRUE);
  TEST ("d0=d2+3.0",((d0=d2+3.0),(d0.get(0,0)==5.0 && d0.get(0,1)==5.0 && d0.get(1,0)==5.0 && d0.get(1,1)==5.0)),1);
  TEST ("d0+=(-3.0)",(d0+=(-3.0),(d0.get(0,0)==2.0 && d0.get(0,1)==2.0 && d0.get(1,0)==2.0 && d0.get(1,1)==2.0)),1);
  Matrix<double> d5(2,2);
  TEST ("d5=d0+d2",((d5=d0+d2),(d5.get(0,0)==4.0 && d5.get(0,1)==4.0 && d5.get(1,0)==4.0 && d5.get(1,1)==4.0)),1);
  TEST ("d0+=d2", ((d0+=d2),(d0.get(0,0)==4.0 && d0.get(0,1)==4.0 && d0.get(1,0)==4.0 && d0.get(1,1)==4.0)),1);
  TEST ("d4=d3*5.0",((d4=d3*5.0),(d4.get(0,0)==5.0 && d4.get(0,1)==10.0 && d4.get(0,2)==15.0)),1);
  TEST ("d3*=5.0",((d3*=5.0),  (d3== d4)), TRUE);
  Matrix<double> d6(2,2,4,1.0,2.0,3.0,4.0);
  TEST ("Matrix<double> d6(2,2,4,1.0,2.0,3.0,4.0)", d6.get(1,1), 4.0);
  Matrix<double> d7(2,2,4,5.0,6.0,7.0,8.0);
  TEST ("Matrix<double> d7(2,2,4,5.0,6.0,7.0,8.0)", d7.get(1,1), 8.0);
  TEST ("d5=d6*d7", ((d5=d6*d7),(d5.get(0,0)==19.0 && d5.get(0,1)==22.0 && d5.get(1,0)==43.0 && d5.get(1,1)==50.0)),1);
  TEST ("d6*=d7", ((d6*=d7),(d6.get(0,0)==19.0 && d6.get(0,1)==22.0 && d6.get(1,0)==43.0 && d6.get(1,1)==50.0)),1);
}

int main (void) {
  START("Matrix");
  test_int ();
  test_double ();
  SUMMARY();
  return 0;
}
