//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 09/11/89 -- Initial design and implementation
//
// The parameterized Matrix<Type>  class is publicly   derived from the  Matrix
// class and implements two dimensional arithmetic matrices of a user specified
// type.   This is accompilshed by using  the parameterized  type capability of
// C++.  The only constraint placed on the type  is  that it must  overload the
// following operators: +, -,  *,  and /. Thus, it will  be possible to have  a
// matrix of  type Complex.  The Matrix<Type> class  is static in size, that is
// once a  Matrix<Type> of  a particular  size has been   declared, there is no
// dynamic growth or resize method available.
//
// The Matrix class is the base class  for the parameterized Matrix<Type> class
// and   implements all non-type   specific  functionality. The  protected data
// section  contains two slots  to maintain the  row and column  specification.
// There are two  constructors  for  the  Matrix  class.  The  first takes  two
// arguments specifying the  number of rows  and columns. The   second takes  a
// reference to a Matrix object and reproduces its state. There  are two public
// methods that provide accessors to the  row and column slots.  Finally, there
// are several protected methods that are called by  the parameterized class to
// handle exceptions.

#ifndef BASE_MATRIXH				// If no Matrix class,
#define BASE_MATRIXH				// define it

#ifndef GENERIC_H				// If no Generic.h file
#include <cool/Generic.h>				// include it
#endif	

class Matrix : public Generic {
protected:
  int num_rows;					// Number of rows
  int num_cols;					// Number of columns

  void get_row_error (const char*, int) CONST;	// Raise exception
  void get_col_error (const char*, int) CONST;	// Raise exception
  void put_row_error (const char*, int) CONST;	// Raise exception
  void put_col_error (const char*, int) CONST;	// Raise exception
  void op_plus_error (const char*, int, int, int, int) CONST;
  void op_mult_error (const char*, int, int, int, int) CONST;
  void op_plus_assign_error(const char*, int, int, int, int) CONST;
  void op_mult_assign_error(const char*, int, int, int, int) CONST;
  
public:
  Matrix (int, int);				// Matrix m (r,c);
  Matrix (const Matrix&);			// m1 = m2;
  ~Matrix();					// Destructor

  inline int rows () CONST;			// Return number of rows
  inline int columns () CONST;			// Return number of columns
};


// rows -- Return the number of rows in the matrix
// Input:  None
// Output: Number of rows

inline int Matrix::rows () CONST {
  return this->num_rows;				// Return number of rows
}


// columns -- Return the number of columns in the matrix
// Intput:    None
// Output:    Number of columns

inline int Matrix::columns () CONST {
  return this->num_cols;			// Return number of columns
}


#endif						// End of BASE_MATRIXH


