//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 06/06/89 -- Initial implementation
// Updated: LGO 09/19/89 -- Split into one file per method
// Updated: MJF 03/12/90 -- Added group names to RAISE
//

#include <cool/Generic.h>
#include <cool/Base_Hash.h>

// resize_error -- Raise exception for Hash_Table::resize()
// Input:          Bad size specification
// Output:         None

void Hash_Table::resize_error (const char* T1, const char* T2, long s) {
  RAISE (Error, SYM(Hash_Table), SYM(Negative_Size),
	 "Hash_Table<%s,%s>::resize(): Negative resize %d", T1, T2, s);
}
