//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: LGO 05/19/89 -- Initial design and implementation
// Updated: MBN 09/18/89 -- Changed package name to uppercase

#include <cool/Generic.h>

#if GENERIC_TYPECHECK

Boolean compare_types(Symbol** typelist, Symbol* type) {
  Symbol** t = typelist;
  while(TRUE) {
    if(*t == type)		// True if type matches
      return(TRUE);
    else if(*++t == NULL)	// False if no base class
      return(FALSE);
    else if (t[1] == NULL)	// If only one base class, check it
      t = (Symbol**) *t;
    else			// else more than one, recurse over them
      while(TRUE)
	if(compare_types(t, type))
	  return(TRUE);
	else if(*++t == NULL)
	  return(FALSE);
  }
}

#endif
