//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MJF 07/05/89 -- Initial design and implementation.
// Updated: MJF 02/22/90 -- New constructor for specifying multiple exceptions.

// An overview of the structure of the Exception class, the Excp_Handler class
// and the exception mechanism for creating, raising and handling an exception
// can be found in the Exception.h header file.

#ifndef STDARGH			// If variable args not defined
# if defined(M_XENIX)
#  include <stdarg.hxx>
# else
#  include <stdarg.h>
# endif
#define STDARGH
#endif

#include <cool/Exception.h>	// include the Exception header file.
#include <cool/Generic.h>	// include the Generic header file.

// **********************************************************************
// Constructor for the Excp_Handler class
// **********************************************************************

// Excp_Handler(Excp_Handler_Function, int, Excp_Type, ...)
//             -- an Excp Handler constructor which initializes 
//                with one or more specified Exception types and
//                an Excp Handler function.
//
// Input:   An Exception Handler function and one or more exception types.
// Output:  None.

Excp_Handler::Excp_Handler(Excp_Handler_Function ehf, int n, Excp_Type et, ...)
{
  this->eh_func = ehf;

  if (n > 0) {
    this->excp_types = (Excp_Type*) new Excp_Type[n+1];
    this->excp_types[0] = et;
    va_list excp_args;
    va_start(excp_args, et);
    for (int i = 1; i < n; i++) {
      this->excp_types[i] = (Excp_Type) va_arg(excp_args, Excp_Type);
    }
    this->excp_types[n] = NULL;  // null terminated array
  } else this->excp_types = NULL;

  if (this->top_handler != this) {
    this->next_handler = this->top_handler;
    this->top_handler = this;
  }
}
